(function() {
  var $$, Point, SelectListView, SymbolsView, fs, path, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  Point = require('atom').Point;

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, SelectListView = _ref.SelectListView;

  fs = require('fs-plus');

  module.exports = SymbolsView = (function(_super) {
    __extends(SymbolsView, _super);

    function SymbolsView() {
      return SymbolsView.__super__.constructor.apply(this, arguments);
    }

    SymbolsView.activate = function() {
      return new SymbolsView;
    };

    SymbolsView.prototype.initialize = function(stack) {
      this.stack = stack;
      SymbolsView.__super__.initialize.apply(this, arguments);
      this.panel = atom.workspace.addModalPanel({
        item: this,
        visible: false
      });
      return this.addClass('symbols-view');
    };

    SymbolsView.prototype.destroy = function() {
      this.cancel();
      return this.panel.destroy();
    };

    SymbolsView.prototype.getFilterKey = function() {
      return 'name';
    };

    SymbolsView.prototype.viewForItem = function(_arg) {
      var directory, file, name, position;
      position = _arg.position, name = _arg.name, file = _arg.file, directory = _arg.directory;
      if (atom.project.getPaths().length > 1) {
        file = path.join(path.basename(directory), file);
      }
      return $$(function() {
        return this.li({
          "class": 'two-lines'
        }, (function(_this) {
          return function() {
            if (position != null) {
              _this.div("" + name + ":" + (position.row + 1), {
                "class": 'primary-line'
              });
            } else {
              _this.div(name, {
                "class": 'primary-line'
              });
            }
            return _this.div(file, {
              "class": 'secondary-line'
            });
          };
        })(this));
      });
    };

    SymbolsView.prototype.getEmptyMessage = function(itemCount) {
      if (itemCount === 0) {
        return 'No symbols found';
      } else {
        return SymbolsView.__super__.getEmptyMessage.apply(this, arguments);
      }
    };

    SymbolsView.prototype.cancelled = function() {
      return this.panel.hide();
    };

    SymbolsView.prototype.confirmed = function(tag) {
      if (tag.file && !fs.isFileSync(path.join(tag.directory, tag.file))) {
        this.setError('Selected file does not exist');
        return setTimeout(((function(_this) {
          return function() {
            return _this.setError();
          };
        })(this)), 2000);
      } else {
        this.cancel();
        return this.openTag(tag);
      }
    };

    SymbolsView.prototype.openTag = function(tag) {
      var editor, position, previous;
      if (editor = atom.workspace.getActiveTextEditor()) {
        previous = {
          position: editor.getCursorBufferPosition(),
          file: editor.getURI()
        };
      }
      position = tag.position;
      if (!position) {
        position = this.getTagLine(tag);
      }
      if (tag.file) {
        atom.workspace.open(path.join(tag.directory, tag.file)).done((function(_this) {
          return function() {
            if (position) {
              return _this.moveToPosition(position);
            }
          };
        })(this));
      } else if (position) {
        this.moveToPosition(position);
      }
      return this.stack.push(previous);
    };

    SymbolsView.prototype.moveToPosition = function(position, beginningOfLine) {
      var editor;
      if (beginningOfLine == null) {
        beginningOfLine = true;
      }
      if (editor = atom.workspace.getActiveTextEditor()) {
        editor.scrollToBufferPosition(position, {
          center: true
        });
        editor.setCursorBufferPosition(position);
        if (beginningOfLine) {
          return editor.moveToFirstCharacterOfLine();
        }
      }
    };

    SymbolsView.prototype.attach = function() {
      this.storeFocusedElement();
      this.panel.show();
      return this.focusFilterEditor();
    };

    SymbolsView.prototype.getTagLine = function(tag) {
      var file, index, line, pattern, _i, _len, _ref1, _ref2;
      pattern = (_ref1 = tag.pattern) != null ? _ref1.replace(/(^^\/\^)|(\$\/$)/g, '').trim() : void 0;
      if (!pattern) {
        return;
      }
      file = path.join(tag.directory, tag.file);
      if (!fs.isFileSync(file)) {
        return;
      }
      _ref2 = fs.readFileSync(file, 'utf8').split('\n');
      for (index = _i = 0, _len = _ref2.length; _i < _len; index = ++_i) {
        line = _ref2[index];
        if (pattern === line.trim()) {
          return new Point(index, 0);
        }
      }
    };

    return SymbolsView;

  })(SelectListView);

}).call(this);
