(function() {
  var BufferedProcess, Point, Q, TagGenerator, path, _ref;

  _ref = require('atom'), BufferedProcess = _ref.BufferedProcess, Point = _ref.Point;

  Q = require('q');

  path = require('path');

  module.exports = TagGenerator = (function() {
    function TagGenerator(path, scopeName) {
      this.path = path;
      this.scopeName = scopeName;
    }

    TagGenerator.prototype.getPackageRoot = function() {
      var packageRoot, resourcePath;
      packageRoot = path.resolve(__dirname, '..');
      resourcePath = atom.getLoadSettings().resourcePath;
      if (path.extname(resourcePath) === '.asar') {
        if (packageRoot.indexOf(resourcePath) === 0) {
          packageRoot = path.join("" + resourcePath + ".unpacked", 'node_modules', 'symbols-view');
        }
      }
      return packageRoot;
    };

    TagGenerator.prototype.parseTagLine = function(line) {
      var sections;
      sections = line.split('\t');
      if (sections.length > 3) {
        return {
          position: new Point(parseInt(sections[2]) - 1),
          name: sections[0]
        };
      } else {
        return null;
      }
    };

    TagGenerator.prototype.getLanguage = function() {
      var _ref1;
      if ((_ref1 = path.extname(this.path)) === '.cson' || _ref1 === '.gyp') {
        return 'Cson';
      }
      switch (this.scopeName) {
        case 'source.c':
          return 'C';
        case 'source.cpp':
          return 'C++';
        case 'source.clojure':
          return 'Lisp';
        case 'source.coffee':
          return 'CoffeeScript';
        case 'source.css':
          return 'Css';
        case 'source.css.less':
          return 'Css';
        case 'source.css.scss':
          return 'Css';
        case 'source.gfm':
          return 'Markdown';
        case 'source.go':
          return 'Go';
        case 'source.java':
          return 'Java';
        case 'source.js':
          return 'JavaScript';
        case 'source.js.jsx':
          return 'JavaScript';
        case 'source.jsx':
          return 'JavaScript';
        case 'source.json':
          return 'Json';
        case 'source.makefile':
          return 'Make';
        case 'source.objc':
          return 'C';
        case 'source.objcpp':
          return 'C++';
        case 'source.python':
          return 'Python';
        case 'source.ruby':
          return 'Ruby';
        case 'source.sass':
          return 'Sass';
        case 'source.yaml':
          return 'Yaml';
        case 'text.html':
          return 'Html';
        case 'text.html.php':
          return 'Php';
      }
    };

    TagGenerator.prototype.generate = function() {
      var args, command, defaultCtagsFile, deferred, exit, language, packageRoot, stderr, stdout, tags;
      deferred = Q.defer();
      tags = {};
      packageRoot = this.getPackageRoot();
      command = path.join(packageRoot, 'vendor', "ctags-" + process.platform);
      defaultCtagsFile = path.join(packageRoot, 'lib', '.ctags');
      args = ["--options=" + defaultCtagsFile, '--fields=+KS'];
      if (atom.config.get('symbols-view.useEditorGrammarAsCtagsLanguage')) {
        if (language = this.getLanguage()) {
          args.push("--language-force=" + language);
        }
      }
      args.push('-nf', '-', this.path);
      stdout = (function(_this) {
        return function(lines) {
          var line, tag, _i, _len, _name, _ref1, _results;
          _ref1 = lines.split('\n');
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            line = _ref1[_i];
            if (tag = _this.parseTagLine(line)) {
              _results.push(tags[_name = tag.position.row] != null ? tags[_name] : tags[_name] = tag);
            } else {
              _results.push(void 0);
            }
          }
          return _results;
        };
      })(this);
      stderr = function() {};
      exit = function() {
        var row, tag;
        tags = (function() {
          var _results;
          _results = [];
          for (row in tags) {
            tag = tags[row];
            _results.push(tag);
          }
          return _results;
        })();
        return deferred.resolve(tags);
      };
      new BufferedProcess({
        command: command,
        args: args,
        stdout: stdout,
        stderr: stderr,
        exit: exit
      });
      return deferred.promise;
    };

    return TagGenerator;

  })();

}).call(this);
