(function() {
  var Task, async, ctags, getTagsFile, handlerPath;

  Task = require('atom').Task;

  ctags = require('ctags');

  async = require('async');

  getTagsFile = require("./get-tags-file");

  handlerPath = require.resolve('./load-tags-handler');

  module.exports = {
    find: function(editor, callback) {
      var allTags, range, symbol;
      if (editor.getLastCursor().getScopeDescriptor().getScopesArray().indexOf('source.ruby') !== -1) {
        range = editor.getLastCursor().getCurrentWordBufferRange({
          wordRegex: /[\w!?]*/g
        });
      } else {
        range = editor.getLastCursor().getCurrentWordBufferRange();
      }
      symbol = editor.getTextInRange(range);
      if (!((symbol != null ? symbol.length : void 0) > 0)) {
        return process.nextTick(function() {
          return callback(null, []);
        });
      }
      allTags = [];
      return async.each(atom.project.getPaths(), function(projectPath, done) {
        var tagsFile;
        tagsFile = getTagsFile(projectPath);
        if (tagsFile == null) {
          return done();
        }
        return ctags.findTags(tagsFile, symbol, function(err, tags) {
          var tag, _i, _len;
          if (tags == null) {
            tags = [];
          }
          for (_i = 0, _len = tags.length; _i < _len; _i++) {
            tag = tags[_i];
            tag.directory = projectPath;
          }
          allTags = allTags.concat(tags);
          return done(err);
        });
      }, function(err) {
        return callback(err, allTags);
      });
    },
    getAllTags: function(callback) {
      var projectTags, task;
      projectTags = [];
      task = Task.once(handlerPath, atom.project.getPaths(), function() {
        return callback(projectTags);
      });
      task.on('tags', function(tags) {
        return projectTags.push.apply(projectTags, tags);
      });
      return task;
    }
  };

}).call(this);
