(function() {
  var BufferPatch, Marker, Range, Serializable,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Serializable = require('serializable');

  Range = require('./range');

  Marker = require('./marker');

  module.exports = BufferPatch = (function(_super) {
    __extends(BufferPatch, _super);

    BufferPatch.prototype.oldMarkersSnapshot = null;

    function BufferPatch(oldRange, newRange, oldText, newText, normalizeLineEndings, newMarkersSnapshot, oldMarkersSnapshot) {
      this.oldRange = oldRange;
      this.newRange = newRange;
      this.oldText = oldText;
      this.newText = newText;
      this.normalizeLineEndings = normalizeLineEndings;
      this.newMarkersSnapshot = newMarkersSnapshot;
      this.oldMarkersSnapshot = oldMarkersSnapshot;
    }

    BufferPatch.prototype.serializeParams = function() {
      var newMarkersSnapshot, newRange, oldMarkersSnapshot, oldRange;
      oldRange = this.oldRange.serialize();
      newRange = this.newRange.serialize();
      newMarkersSnapshot = Marker.serializeSnapshot(this.newMarkersSnapshot);
      oldMarkersSnapshot = Marker.serializeSnapshot(this.oldMarkersSnapshot);
      return {
        oldRange: oldRange,
        newRange: newRange,
        oldText: this.oldText,
        newText: this.newText,
        normalizeLineEndings: this.normalizeLineEndings,
        newMarkersSnapshot: newMarkersSnapshot,
        oldMarkersSnapshot: oldMarkersSnapshot
      };
    };

    BufferPatch.prototype.deserializeParams = function(params) {
      params.oldRange = Range.deserialize(params.oldRange);
      params.newRange = Range.deserialize(params.newRange);
      params.newMarkersSnapshot = Marker.deserializeSnapshot(params.newMarkersSnapshot);
      params.oldMarkersSnapshot = Marker.deserializeSnapshot(params.oldMarkersSnapshot);
      return params;
    };

    BufferPatch.prototype.invert = function(buffer) {
      return new this.constructor(this.newRange, this.oldRange, this.newText, this.oldText, this.normalizeLineEndings, this.oldMarkersSnapshot);
    };

    BufferPatch.prototype.applyTo = function(buffer) {
      return buffer.applyPatch(this);
    };

    return BufferPatch;

  })(Serializable);

}).call(this);
