(function() {
  var AddDialog, Dialog, fs, path, relativizePath, repoForPath, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  _ref = require('./helpers'), repoForPath = _ref.repoForPath, relativizePath = _ref.relativizePath;

  module.exports = AddDialog = (function(_super) {
    __extends(AddDialog, _super);

    function AddDialog(initialPath, isCreatingFile) {
      var directoryPath, relativeDirectoryPath, _ref1;
      this.isCreatingFile = isCreatingFile;
      if (fs.isFileSync(initialPath)) {
        directoryPath = path.dirname(initialPath);
      } else {
        directoryPath = initialPath;
      }
      relativeDirectoryPath = directoryPath;
      _ref1 = relativizePath(directoryPath), this.rootProjectPath = _ref1[0], relativeDirectoryPath = _ref1[1];
      if (relativeDirectoryPath.length > 0) {
        relativeDirectoryPath += path.sep;
      }
      AddDialog.__super__.constructor.call(this, {
        prompt: "Enter the path for the new " + (isCreatingFile ? "file." : "folder."),
        initialPath: relativeDirectoryPath,
        select: false,
        iconClass: isCreatingFile ? 'icon-file-add' : 'icon-file-directory-create'
      });
    }

    AddDialog.prototype.onConfirm = function(newPath) {
      var endsWithDirectorySeparator, error, _ref1;
      newPath = newPath.replace(/\s+$/, '');
      endsWithDirectorySeparator = newPath[newPath.length - 1] === path.sep;
      if (!path.isAbsolute(newPath)) {
        if (this.rootProjectPath == null) {
          this.showError("You must open a directory to create a file with a relative path");
          return;
        }
        newPath = path.join(this.rootProjectPath, newPath);
      }
      if (!newPath) {
        return;
      }
      try {
        if (fs.existsSync(newPath)) {
          return this.showError("'" + newPath + "' already exists.");
        } else if (this.isCreatingFile) {
          if (endsWithDirectorySeparator) {
            return this.showError("File names must not end with a '" + path.sep + "' character.");
          } else {
            fs.writeFileSync(newPath, '');
            if ((_ref1 = repoForPath(newPath)) != null) {
              _ref1.getPathStatus(newPath);
            }
            this.trigger('file-created', [newPath]);
            return this.close();
          }
        } else {
          fs.makeTreeSync(newPath);
          this.trigger('directory-created', [newPath]);
          return this.cancel();
        }
      } catch (_error) {
        error = _error;
        return this.showError("" + error.message + ".");
      }
    };

    return AddDialog;

  })(Dialog);

}).call(this);
