(function() {
  var CompositeDisposable, Directory, DirectoryElement, DirectoryView, FileView, repoForPath,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require('event-kit').CompositeDisposable;

  Directory = require('./directory');

  FileView = require('./file-view');

  repoForPath = require('./helpers').repoForPath;

  DirectoryView = (function(_super) {
    __extends(DirectoryView, _super);

    function DirectoryView() {
      return DirectoryView.__super__.constructor.apply(this, arguments);
    }

    DirectoryView.prototype.initialize = function(directory) {
      var iconClass, _ref;
      this.directory = directory;
      this.subscriptions = new CompositeDisposable();
      this.subscriptions.add(this.directory.onDidDestroy((function(_this) {
        return function() {
          return _this.subscriptions.dispose();
        };
      })(this)));
      this.subscribeToDirectory();
      this.classList.add('directory', 'entry', 'list-nested-item', 'collapsed');
      this.header = document.createElement('div');
      this.appendChild(this.header);
      this.header.classList.add('header', 'list-item');
      this.directoryName = document.createElement('span');
      this.header.appendChild(this.directoryName);
      this.directoryName.classList.add('name', 'icon');
      this.entries = document.createElement('ol');
      this.appendChild(this.entries);
      this.entries.classList.add('entries', 'list-tree');
      if (this.directory.symlink) {
        iconClass = 'icon-file-symlink-directory';
      } else {
        iconClass = 'icon-file-directory';
        if (this.directory.isRoot) {
          if ((_ref = repoForPath(this.directory.path)) != null ? _ref.isProjectAtRoot() : void 0) {
            iconClass = 'icon-repo';
          }
        } else {
          if (this.directory.submodule) {
            iconClass = 'icon-file-submodule';
          }
        }
      }
      this.directoryName.classList.add(iconClass);
      this.directoryName.textContent = this.directory.name;
      this.directoryName.dataset.name = this.directory.name;
      this.directoryName.dataset.path = this.directory.path;
      if (this.directory.isRoot) {
        this.classList.add('project-root');
      } else {
        this.subscriptions.add(this.directory.onDidStatusChange((function(_this) {
          return function() {
            return _this.updateStatus();
          };
        })(this)));
        this.updateStatus();
      }
      if (this.directory.expansionState.isExpanded) {
        return this.expand();
      }
    };

    DirectoryView.prototype.updateStatus = function() {
      this.classList.remove('status-ignored', 'status-modified', 'status-added');
      if (this.directory.status != null) {
        return this.classList.add("status-" + this.directory.status);
      }
    };

    DirectoryView.prototype.subscribeToDirectory = function() {
      return this.subscriptions.add(this.directory.onDidAddEntries((function(_this) {
        return function(addedEntries) {
          var entry, insertionIndex, numberOfEntries, view, _i, _len, _results;
          if (!_this.isExpanded) {
            return;
          }
          numberOfEntries = _this.entries.children.length;
          _results = [];
          for (_i = 0, _len = addedEntries.length; _i < _len; _i++) {
            entry = addedEntries[_i];
            view = _this.createViewForEntry(entry);
            insertionIndex = entry.indexInParentDirectory;
            if (insertionIndex < numberOfEntries) {
              _this.entries.insertBefore(view, _this.entries.children[insertionIndex]);
            } else {
              _this.entries.appendChild(view);
            }
            _results.push(numberOfEntries++);
          }
          return _results;
        };
      })(this)));
    };

    DirectoryView.prototype.getPath = function() {
      return this.directory.path;
    };

    DirectoryView.prototype.isPathEqual = function(pathToCompare) {
      return this.directory.isPathEqual(pathToCompare);
    };

    DirectoryView.prototype.createViewForEntry = function(entry) {
      var subscription, view;
      if (entry instanceof Directory) {
        view = new DirectoryElement();
      } else {
        view = new FileView();
      }
      view.initialize(entry);
      subscription = this.directory.onDidRemoveEntries(function(removedEntries) {
        var removedEntry, removedName, _results;
        _results = [];
        for (removedName in removedEntries) {
          removedEntry = removedEntries[removedName];
          if (!(entry === removedEntry)) {
            continue;
          }
          view.remove();
          subscription.dispose();
          break;
        }
        return _results;
      });
      this.subscriptions.add(subscription);
      return view;
    };

    DirectoryView.prototype.reload = function() {
      if (this.isExpanded) {
        return this.directory.reload();
      }
    };

    DirectoryView.prototype.toggleExpansion = function(isRecursive) {
      if (isRecursive == null) {
        isRecursive = false;
      }
      if (this.isExpanded) {
        return this.collapse(isRecursive);
      } else {
        return this.expand(isRecursive);
      }
    };

    DirectoryView.prototype.expand = function(isRecursive) {
      var entry, _i, _len, _ref;
      if (isRecursive == null) {
        isRecursive = false;
      }
      if (!this.isExpanded) {
        this.isExpanded = true;
        this.classList.add('expanded');
        this.classList.remove('collapsed');
        this.directory.expand();
      }
      if (isRecursive) {
        _ref = this.entries.children;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          entry = _ref[_i];
          if (entry instanceof DirectoryView) {
            entry.expand(true);
          }
        }
      }
      return false;
    };

    DirectoryView.prototype.collapse = function(isRecursive) {
      var entry, _i, _len, _ref;
      if (isRecursive == null) {
        isRecursive = false;
      }
      this.isExpanded = false;
      if (isRecursive) {
        _ref = this.entries.children;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          entry = _ref[_i];
          if (entry.isExpanded) {
            entry.collapse(true);
          }
        }
      }
      this.classList.remove('expanded');
      this.classList.add('collapsed');
      this.directory.collapse();
      return this.entries.innerHTML = '';
    };

    return DirectoryView;

  })(HTMLElement);

  DirectoryElement = document.registerElement('tree-view-directory', {
    prototype: DirectoryView.prototype,
    "extends": 'li'
  });

  module.exports = DirectoryElement;

}).call(this);
