(function() {
  var CompositeDisposable, FileView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require('event-kit').CompositeDisposable;

  module.exports = FileView = (function(_super) {
    __extends(FileView, _super);

    function FileView() {
      return FileView.__super__.constructor.apply(this, arguments);
    }

    FileView.prototype.initialize = function(file) {
      this.file = file;
      this.subscriptions = new CompositeDisposable();
      this.subscriptions.add(this.file.onDidDestroy((function(_this) {
        return function() {
          return _this.subscriptions.dispose();
        };
      })(this)));
      this.classList.add('file', 'entry', 'list-item');
      this.fileName = document.createElement('span');
      this.fileName.classList.add('name', 'icon');
      this.appendChild(this.fileName);
      this.fileName.textContent = this.file.name;
      this.fileName.dataset.name = this.file.name;
      this.fileName.dataset.path = this.file.path;
      if (this.file.symlink) {
        this.fileName.classList.add('icon-file-symlink-file');
      } else {
        switch (this.file.type) {
          case 'binary':
            this.fileName.classList.add('icon-file-binary');
            break;
          case 'compressed':
            this.fileName.classList.add('icon-file-zip');
            break;
          case 'image':
            this.fileName.classList.add('icon-file-media');
            break;
          case 'pdf':
            this.fileName.classList.add('icon-file-pdf');
            break;
          case 'readme':
            this.fileName.classList.add('icon-book');
            break;
          case 'text':
            this.fileName.classList.add('icon-file-text');
        }
      }
      this.subscriptions.add(this.file.onDidStatusChange((function(_this) {
        return function() {
          return _this.updateStatus();
        };
      })(this)));
      return this.updateStatus();
    };

    FileView.prototype.updateStatus = function() {
      this.classList.remove('status-ignored', 'status-modified', 'status-added');
      if (this.file.status != null) {
        return this.classList.add("status-" + this.file.status);
      }
    };

    FileView.prototype.getPath = function() {
      return this.fileName.dataset.path;
    };

    FileView.prototype.isPathEqual = function(pathToCompare) {
      return this.file.isPathEqual(pathToCompare);
    };

    return FileView;

  })(HTMLElement);

  module.exports = document.registerElement('tree-view-file', {
    prototype: FileView.prototype,
    "extends": 'li'
  });

}).call(this);
