(function() {
  var CompositeDisposable, Emitter, File, fs, path, repoForPath, _ref;

  path = require('path');

  fs = require('fs-plus');

  _ref = require('event-kit'), CompositeDisposable = _ref.CompositeDisposable, Emitter = _ref.Emitter;

  repoForPath = require('./helpers').repoForPath;

  module.exports = File = (function() {
    function File(_arg) {
      var extension, fullPath, realpathCache;
      this.name = _arg.name, fullPath = _arg.fullPath, this.symlink = _arg.symlink, realpathCache = _arg.realpathCache;
      this.emitter = new Emitter();
      this.subscriptions = new CompositeDisposable();
      this.path = fullPath;
      this.realPath = this.path;
      extension = path.extname(this.path);
      if (fs.isReadmePath(this.path)) {
        this.type = 'readme';
      } else if (fs.isCompressedExtension(extension)) {
        this.type = 'compressed';
      } else if (fs.isImageExtension(extension)) {
        this.type = 'image';
      } else if (fs.isPdfExtension(extension)) {
        this.type = 'pdf';
      } else if (fs.isBinaryExtension(extension)) {
        this.type = 'binary';
      } else {
        this.type = 'text';
      }
      this.subscribeToRepo();
      this.updateStatus();
      fs.realpath(this.path, realpathCache, (function(_this) {
        return function(error, realPath) {
          if (realPath && realPath !== _this.path) {
            _this.realPath = realPath;
            return _this.updateStatus();
          }
        };
      })(this));
    }

    File.prototype.destroy = function() {
      this.subscriptions.dispose();
      return this.emitter.emit('did-destroy');
    };

    File.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    File.prototype.onDidStatusChange = function(callback) {
      return this.emitter.on('did-status-change', callback);
    };

    File.prototype.subscribeToRepo = function() {
      var repo;
      repo = repoForPath(this.path);
      if (repo == null) {
        return;
      }
      this.subscriptions.add(repo.onDidChangeStatus((function(_this) {
        return function(event) {
          if (_this.isPathEqual(event.path)) {
            return _this.updateStatus(repo);
          }
        };
      })(this)));
      return this.subscriptions.add(repo.onDidChangeStatuses((function(_this) {
        return function() {
          return _this.updateStatus(repo);
        };
      })(this)));
    };

    File.prototype.updateStatus = function() {
      var newStatus, repo, status;
      repo = repoForPath(this.path);
      if (repo == null) {
        return;
      }
      newStatus = null;
      if (repo.isPathIgnored(this.path)) {
        newStatus = 'ignored';
      } else {
        status = repo.getCachedPathStatus(this.path);
        if (repo.isStatusModified(status)) {
          newStatus = 'modified';
        } else if (repo.isStatusNew(status)) {
          newStatus = 'added';
        }
      }
      if (newStatus !== this.status) {
        this.status = newStatus;
        return this.emitter.emit('did-status-change', newStatus);
      }
    };

    File.prototype.isPathEqual = function(pathToCompare) {
      return this.path === pathToCompare || this.realPath === pathToCompare;
    };

    return File;

  })();

}).call(this);
