(function() {
  var CompositeDisposable, path;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  path = require('path');

  module.exports = {
    config: {
      hideVcsIgnoredFiles: {
        type: 'boolean',
        "default": false,
        title: 'Hide VCS Ignored Files'
      },
      hideIgnoredNames: {
        type: 'boolean',
        "default": false
      },
      showOnRightSide: {
        type: 'boolean',
        "default": false
      },
      sortFoldersBeforeFiles: {
        type: 'boolean',
        "default": true
      }
    },
    treeView: null,
    activate: function(state) {
      var _base;
      this.state = state;
      this.disposables = new CompositeDisposable;
      if (this.shouldAttach()) {
        if ((_base = this.state).attached == null) {
          _base.attached = true;
        }
      }
      if (this.state.attached) {
        this.createView();
      }
      return this.disposables.add(atom.commands.add('atom-workspace', {
        'tree-view:show': (function(_this) {
          return function() {
            return _this.createView().show();
          };
        })(this),
        'tree-view:toggle': (function(_this) {
          return function() {
            return _this.createView().toggle();
          };
        })(this),
        'tree-view:toggle-focus': (function(_this) {
          return function() {
            return _this.createView().toggleFocus();
          };
        })(this),
        'tree-view:reveal-active-file': (function(_this) {
          return function() {
            return _this.createView().revealActiveFile();
          };
        })(this),
        'tree-view:toggle-side': (function(_this) {
          return function() {
            return _this.createView().toggleSide();
          };
        })(this),
        'tree-view:add-file': (function(_this) {
          return function() {
            return _this.createView().add(true);
          };
        })(this),
        'tree-view:add-folder': (function(_this) {
          return function() {
            return _this.createView().add(false);
          };
        })(this),
        'tree-view:duplicate': (function(_this) {
          return function() {
            return _this.createView().copySelectedEntry();
          };
        })(this),
        'tree-view:remove': (function(_this) {
          return function() {
            return _this.createView().removeSelectedEntries();
          };
        })(this),
        'tree-view:rename': (function(_this) {
          return function() {
            return _this.createView().moveSelectedEntry();
          };
        })(this)
      }));
    },
    deactivate: function() {
      var _ref;
      this.disposables.dispose();
      if ((_ref = this.treeView) != null) {
        _ref.deactivate();
      }
      return this.treeView = null;
    },
    serialize: function() {
      if (this.treeView != null) {
        return this.treeView.serialize();
      } else {
        return this.state;
      }
    },
    createView: function() {
      var TreeView;
      if (this.treeView == null) {
        TreeView = require('./tree-view');
        this.treeView = new TreeView(this.state);
      }
      return this.treeView;
    },
    shouldAttach: function() {
      var projectPath;
      projectPath = atom.project.getPaths()[0];
      if (atom.workspace.getActivePaneItem()) {
        return false;
      } else if (path.basename(projectPath) === '.git') {
        return projectPath === atom.getLoadSettings().pathToOpen;
      } else {
        return true;
      }
    }
  };

}).call(this);
