(function() {
  var BufferedProcess, ProgressElement;

  BufferedProcess = require('atom').BufferedProcess;

  ProgressElement = require('./progress-element');

  module.exports = {
    activate: function() {
      return atom.commands.add("atom-workspace", 'update-package-dependencies:update', (function(_this) {
        return function() {
          return _this.update();
        };
      })(this));
    },
    update: function() {
      var args, command, exit, options, panel, view;
      view = new ProgressElement;
      view.displayLoading();
      panel = atom.workspace.addModalPanel({
        item: view
      });
      command = atom.packages.getApmPath();
      args = ['install'];
      options = {
        cwd: this.getActiveProjectPath()
      };
      exit = function(code) {
        view.focus();
        atom.commands.add(view, 'core:cancel', function() {
          return panel.destroy();
        });
        if (code === 0) {
          return view.displaySuccess();
        } else {
          return view.displayFailure();
        }
      };
      return this.runBufferedProcess({
        command: command,
        args: args,
        exit: exit,
        options: options
      });
    },
    runBufferedProcess: function(params) {
      return new BufferedProcess(params);
    },
    getActiveProjectPath: function() {
      var activeItemPath, _ref;
      if (activeItemPath = (_ref = atom.workspace.getActivePaneItem()) != null ? typeof _ref.getPath === "function" ? _ref.getPath() : void 0 : void 0) {
        return atom.project.relativizePath(activeItemPath)[0];
      } else {
        return atom.project.getPaths()[0];
      }
    }
  };

}).call(this);
