(function() {
  var UpdatePackageDependencies, os;

  os = require("os");

  UpdatePackageDependencies = require('../lib/update-package-dependencies');

  describe("Update Package Dependencies", function() {
    var mainModule, projectPath, workspaceElement, _ref;
    _ref = [], workspaceElement = _ref[0], mainModule = _ref[1], projectPath = _ref[2];
    beforeEach(function() {
      projectPath = __dirname;
      workspaceElement = atom.views.getView(atom.workspace);
      atom.project.setPaths([projectPath]);
      return waitsForPromise(function() {
        return atom.packages.activatePackage('update-package-dependencies').then(function(pack) {
          return mainModule = pack.mainModule, pack;
        });
      });
    });
    return describe("the update-package-dependencies:update command", function() {
      beforeEach(function() {
        return spyOn(mainModule, 'runBufferedProcess');
      });
      it("updates package dependencies", function() {
        var args, command, options, _ref1;
        atom.commands.dispatch(workspaceElement, "update-package-dependencies:update");
        expect(mainModule.runBufferedProcess).toHaveBeenCalled();
        _ref1 = mainModule.runBufferedProcess.argsForCall[0][0], command = _ref1.command, args = _ref1.args, options = _ref1.options;
        expect(command).toMatch(/apm$/);
        expect(args).toEqual(["install"]);
        return expect(options.cwd).toEqual(projectPath);
      });
      it("displays a progress modal", function() {
        var modal;
        atom.commands.dispatch(workspaceElement, "update-package-dependencies:update");
        modal = atom.workspace.getModalPanels()[0];
        expect(modal.getItem().querySelector(".loading")).not.toBeNull();
        return expect(modal.getItem().textContent).toMatch(/Updating package dependencies/);
      });
      describe("when there are multiple project paths", function() {
        beforeEach(function() {
          return atom.project.setPaths([os.tmpDir(), projectPath]);
        });
        return it("uses the currently active one", function() {
          waitsForPromise(function() {
            return atom.workspace.open(path.join(projectPath, "package.json"));
          });
          return runs(function() {
            var options;
            atom.commands.dispatch(workspaceElement, "update-package-dependencies:update");
            options = mainModule.runBufferedProcess.argsForCall[0][0].options;
            return expect(options.cwd).toEqual(projectPath);
          });
        });
      });
      describe("when the update succeeds", function() {
        beforeEach(function() {
          var exit;
          atom.commands.dispatch(workspaceElement, "update-package-dependencies:update");
          exit = mainModule.runBufferedProcess.argsForCall[0][0].exit;
          return exit(0);
        });
        it("shows a success message in the modal", function() {
          var modal;
          modal = atom.workspace.getModalPanels()[0];
          expect(modal.getItem().querySelector(".loading")).toBeNull();
          return expect(modal.getItem().textContent).toMatch(/Package dependencies updated/);
        });
        return describe("triggering core:cancel", function() {
          return it("dismisses the modal", function() {
            var modal;
            modal = atom.workspace.getModalPanels()[0];
            atom.commands.dispatch(modal.getItem(), 'core:cancel');
            return expect(atom.workspace.getModalPanels().length).toBe(0);
          });
        });
      });
      return describe("when the update fails", function() {
        beforeEach(function() {
          var exit;
          atom.commands.dispatch(workspaceElement, "update-package-dependencies:update");
          exit = mainModule.runBufferedProcess.argsForCall[0][0].exit;
          return exit(127);
        });
        return it("shows a failure message in the modal", function() {
          var modal;
          modal = atom.workspace.getModalPanels()[0];
          expect(modal.getItem().querySelector(".loading")).toBeNull();
          return expect(modal.getItem().textContent).toMatch(/Failed to update package depencencies/);
        });
      });
    });
  });

}).call(this);
