<?php
/**
 * Created by PhpStorm.
 * User: phpox
 * Date: 2015/10/6
 * Time: 10:39
 */

if (!defined('ROOT'))
    exit('Can\'t Access !');

class ueditor_act extends act {

    function init() {
        set_time_limit(0);
        include ROOT."/lib/plugins/Uploader.class.php";
    }

    function config(){
        $arr['imageActionName'] = 'uploadimage';
        $arr['imageFieldName'] = 'upfile';
        $arr['imageMaxSize'] = 2048000;
        $arr['imageAllowFiles'] = array('.png','.jpg','.jpeg','.gif','.bmp');
        $arr['imageCompressEnable'] = true;
        $arr['imageCompressBorder'] = 1600;
        $arr['imageInsertAlign'] = 'none';
        $arr['imageUrlPrefix'] = '';
        $arr['imagePathFormat'] = '/upload/images/{yyyy}{mm}/{time}{rand:4}';

        /* ͿѻͼƬϴ */
        $arr['scrawlActionName'] =  'uploadscrawl'; /* ִϴͿѻaction */
        $arr['scrawlFieldName'] = 'upfile'; /* ύͼƬ */
        $arr['scrawlPathFormat'] = '/upload/images/{yyyy}{mm}/{time}{rand:4}'; /* ϴ·,Զ屣·ļʽ */
        $arr['scrawlMaxSize'] = 2048000; /* ϴСƣλB */
        $arr['scrawlUrlPrefix'] = ''; /* ͼƬ·ǰ׺ */
        $arr['scrawlInsertAlign'] = 'none';

        /* ͼϴ */
        $arr['snapscreenActionName'] = 'uploadimage'; /* ִϴͼaction */
        $arr['snapscreenPathFormat'] = '/upload/images/{yyyy}{mm}/{time}{rand:4}'; /* ϴ·,Զ屣·ļʽ */
        $arr['snapscreenUrlPrefix'] = ''; /* ͼƬ·ǰ׺ */
        $arr['snapscreenInsertAlign'] = 'none'; /* ͼƬʽ */

        /* ץȡԶͼƬ */
        $arr['catcherLocalDomain'] = array("127.0.0.1", "localhost", "img.baidu.com");
        $arr['catcherActionName'] = 'catchimage'; /* ִץȡԶͼƬaction */
        $arr['catcherFieldName'] = 'source'; /* ύͼƬб */
        $arr['catcherPathFormat'] = '/upload/images/{yyyy}{mm}/{time}{rand:4}'; /* ϴ·,Զ屣·ļʽ */
        $arr['catcherUrlPrefix'] = ''; /* ͼƬ·ǰ׺ */
        $arr['catcherMaxSize'] = 2048000; /* ϴСƣλB */
        $arr['catcherAllowFiles'] = array(".png", ".jpg", ".jpeg", ".gif", ".bmp"); /* ץȡͼƬʽʾ */

        /* ϴƵ */
        $arr['videoActionName'] = 'uploadvideo'; /* ִϴƵaction */
        $arr['videoFieldName'] = 'upfile'; /* ύƵ */
        $arr['videoPathFormat'] = '/upload/videos/{yyyy}{mm}/{time}{rand:4}'; /* ϴ·,Զ屣·ļʽ */
        $arr['videoUrlPrefix'] = ''; /* Ƶ·ǰ׺ */
        $arr['videoMaxSize'] = 102400000; /* ϴСƣλBĬ100MB */
        $arr['videoAllowFiles'] = array(
            ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
            ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid"
        ); /* ϴƵʽʾ */

        /* ϴļ */
        $arr['fileActionName'] = 'uploadfile'; /* controller,ִϴƵaction */
        $arr['fileFieldName'] = 'upfile'; /* ύļ */
        $arr['filePathFormat'] = '/upload/files/{yyyy}{mm}/{time}{rand:4}'; /* ϴ·,Զ屣·ļʽ */
        $arr['fileUrlPrefix'] = ''; /* ļ·ǰ׺ */
        $arr['fileMaxSize'] = 51200000; /* ϴСƣλBĬ50MB */
        $arr['fileAllowFiles'] = array(
                ".png", ".jpg", ".jpeg", ".gif", ".bmp",
                ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid",
                ".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso",
                ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"
        ); /* ϴļʽʾ */

        /* гָĿ¼µͼƬ */
        $arr['imageManagerActionName'] = 'listimage'; /* ִͼƬaction */
        $arr['imageManagerListPath'] = '/upload/images/'; /* ָҪгͼƬĿ¼ */
        $arr['imageManagerListSize'] = 20; /* ÿгļ */
        $arr['imageManagerUrlPrefix'] = ''; /* ͼƬ·ǰ׺ */
        $arr['imageManagerInsertAlign'] = 'none'; /* ͼƬʽ */
        $arr['imageManagerAllowFiles'] = array(".png", ".jpg", ".jpeg", ".gif", ".bmp"); /* гļ */

        /* гָĿ¼µļ */
        $arr['fileManagerActionName'] = 'listfile'; /* ִļaction */
        $arr['fileManagerListPath'] = '/upload/files/'; /* ָҪгļĿ¼ */
        $arr['fileManagerUrlPrefix'] = ''; /* ļ·ǰ׺ */
        $arr['fileManagerListSize'] = 20; /* ÿгļ */
        $arr['fileManagerAllowFiles'] = array(
                ".png", ".jpg", ".jpeg", ".gif", ".bmp",
                ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid",
                ".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso",
                ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"
        );
        return json_encode($arr);
    }

    function upload(){
        $CONFIG = json_decode($this->config(),true);
        /* ϴ */
        $base64 = "upload";
        switch (htmlspecialchars($_GET['action'])) {
            case 'uploadimage':
                $config = array(
                    "pathFormat" => $CONFIG['imagePathFormat'],
                    "maxSize" => $CONFIG['imageMaxSize'],
                    "allowFiles" => $CONFIG['imageAllowFiles']
                );
                $fieldName = $CONFIG['imageFieldName'];
                break;
            case 'uploadscrawl':
                $config = array(
                    "pathFormat" => $CONFIG['scrawlPathFormat'],
                    "maxSize" => $CONFIG['scrawlMaxSize'],
                    "allowFiles" => $CONFIG['scrawlAllowFiles'],
                    "oriName" => "scrawl.png"
                );
                $fieldName = $CONFIG['scrawlFieldName'];
                $base64 = "base64";
                break;
            case 'uploadvideo':
                $config = array(
                    "pathFormat" => $CONFIG['videoPathFormat'],
                    "maxSize" => $CONFIG['videoMaxSize'],
                    "allowFiles" => $CONFIG['videoAllowFiles']
                );
                $fieldName = $CONFIG['videoFieldName'];
                break;
            case 'uploadfile':
            default:
                $config = array(
                    "pathFormat" => $CONFIG['filePathFormat'],
                    "maxSize" => $CONFIG['fileMaxSize'],
                    "allowFiles" => $CONFIG['fileAllowFiles']
                );
                $fieldName = $CONFIG['fileFieldName'];
                break;
        }

        /* ϴʵϴ */
        $up = new Uploader($fieldName, $config, $base64);

        /**
         * õϴļӦĸ,ṹ
         * array(
         *     "state" => "",          //ϴ״̬ϴɹʱ뷵"SUCCESS"
         *     "url" => "",            //صĵַ
         *     "title" => "",          //ļ
         *     "original" => "",       //ԭʼļ
         *     "type" => ""            //ļ
         *     "size" => "",           //ļС
         * )
         */

        /*  */
        return json_encode($up->getFileInfo());

    }

    function actList(){
        $CONFIG = json_decode($this->config(),true);
        /* ж */
        switch ($_GET['action']) {
            /* гļ */
            case 'listfile':
                $allowFiles = $CONFIG['fileManagerAllowFiles'];
                $listSize = $CONFIG['fileManagerListSize'];
                $path = $CONFIG['fileManagerListPath'];
                break;
            /* гͼƬ */
            case 'listimage':
            default:
                $allowFiles = $CONFIG['imageManagerAllowFiles'];
                $listSize = $CONFIG['imageManagerListSize'];
                $path = $CONFIG['imageManagerListPath'];
        }
        $allowFiles = substr(str_replace(".", "|", join("", $allowFiles)), 1);

        /* ȡ */
        $size = isset($_GET['size']) ? htmlspecialchars($_GET['size']) : $listSize;
        $start = isset($_GET['start']) ? htmlspecialchars($_GET['start']) : 0;
        $end = $start + $size;

        /* ȡļб */
        $path = $_SERVER['DOCUMENT_ROOT'] . (substr($path, 0, 1) == "/" ? "":"/") . $path;
        $files = $this->getfiles($path, $allowFiles);
        if (!count($files)) {
            return json_encode(array(
                "state" => "no match file",
                "list" => array(),
                "start" => $start,
                "total" => count($files)
            ));
        }

        /* ȡָΧб */
        $len = count($files);
        for ($i = min($end, $len) - 1, $list = array(); $i < $len && $i >= 0 && $i >= $start; $i--){
            $list[] = $files[$i];
        }
        //
        //for ($i = $end, $list = array(); $i < $len && $i < $end; $i++){
        //    $list[] = $files[$i];
        //}

        /*  */
        $result = json_encode(array(
            "state" => "SUCCESS",
            "list" => $list,
            "start" => $start,
            "total" => count($files)
        ));

        return $result;
    }

    /**
     * ȡĿ¼µָ͵ļ
     * @param $path
     * @param array $files
     * @return array
     */
    function getfiles($path, $allowFiles, &$files = array())
    {
        if (!is_dir($path)) return null;
        if(substr($path, strlen($path) - 1) != '/') $path .= '/';
        $handle = opendir($path);
        while (false !== ($file = readdir($handle))) {
            if ($file != '.' && $file != '..') {
                $path2 = $path . $file;
                if (is_dir($path2)) {
                    $this->getfiles($path2, $allowFiles, $files);
                } else {
                    if (preg_match("/\.(".$allowFiles.")$/i", $file)) {
                        $files[] = array(
                            'url'=> substr($path2, strlen($_SERVER['DOCUMENT_ROOT'])),
                            'mtime'=> filemtime($path2)
                        );
                    }
                }
            }
        }
        return $files;
    }

    function crawler(){
        $CONFIG = json_decode($this->config(),true);
        /* ϴ */
        $config = array(
            "pathFormat" => $CONFIG['catcherPathFormat'],
            "maxSize" => $CONFIG['catcherMaxSize'],
            "allowFiles" => $CONFIG['catcherAllowFiles'],
            "oriName" => "remote.png"
        );
        $fieldName = $CONFIG['catcherFieldName'];

        /* ץȡԶͼƬ */
        $list = array();
        if (isset($_POST[$fieldName])) {
            $source = $_POST[$fieldName];
        } else {
            $source = $_GET[$fieldName];
        }
        foreach ($source as $imgUrl) {
            $item = new Uploader($imgUrl, $config, "remote");
            $info = $item->getFileInfo();
            array_push($list, array(
                "state" => $info["state"],
                "url" => $info["url"],
                "size" => $info["size"],
                "title" => htmlspecialchars($info["title"]),
                "original" => htmlspecialchars($info["original"]),
                "source" => htmlspecialchars($imgUrl)
            ));
        }

        /* ץȡ */
        return json_encode(array(
            'state'=> count($list) ? 'SUCCESS':'ERROR',
            'list'=> $list
        ));
    }

    function index_action() {
        $action = $_GET['action'];
        switch ($action) {
            case 'config':
                $result =  $this->config();
                break;

            /* ϴͼƬ */
            case 'uploadimage':
                /* ϴͿѻ */
            case 'uploadscrawl':
                /* ϴƵ */
            case 'uploadvideo':
                /* ϴļ */
            case 'uploadfile':
                $result = $this->upload();
                break;

            /* гͼƬ */
            case 'listimage':
                $result = $this->actList();
                break;
            /* гļ */
            case 'listfile':
                $result = $this->actList();
                break;

            /* ץȡԶļ */
            case 'catchimage':
                $result = $this->crawler();
                break;

            default:
                $result = json_encode(array(
                    'state'=> 'ַ'
                ));
                break;
        }

        /*  */
        if (isset($_GET["callback"])) {
            if (preg_match("/^[\w_]+$/", $_GET["callback"])) {
                echo htmlspecialchars($_GET["callback"]) . '(' . $result . ')';
            } else {
                echo json_encode(array(
                    'state'=> 'callbackϷ'
                ));
            }
        } else {
            echo $result;
        }
    }
}