//
//  SQLiteManagerCodeMaker.h
//  XXXARC
//
//  Created by @iosxtools on Twitter 9/4/13.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//

#import "CommonMaker.h"
typedef void(^CodeMakerCallbackBlock)();
@class SQLiteTable;
@interface SQLiteManagerCodeMaker : NSObject
@property(nonatomic,strong)NSArray *tables;
+ (SQLiteManagerCodeMaker*)sharedInstance;
- (void)makeCommonFile;
- (void)make;
- (void)makeModelFile;
- (void)makeDAOFile;
- (void)makeWithCallBack:(CodeMakerCallbackBlock)callBack;
- (void)makeModelFileWithCallBack:(CodeMakerCallbackBlock)callBack;
- (void)makeDAOFileWithCallBack:(CodeMakerCallbackBlock)callBack;
- (void)clearModelFile;
- (void)clearDAOFile;
- (void)clearAllFile;
- (void)clearModelFile:(NSString*)tableName;
- (void)clearDaoFile:(NSString*)tableName;
- (void)clearModelFileWithCallBack:(CodeMakerCallbackBlock)callBack;

- (void)clearDAOFileWithCallBack:(CodeMakerCallbackBlock)callBack;

- (void)clearAllFileWithCallBack:(CodeMakerCallbackBlock)callBack;

- (void)refreshCodeStyle:(NSString*)style;
- (NSString*)readModelHFile:(NSString*)name;
- (NSString*)readModelMFile:(NSString*)name;
- (NSString*)readDAOHFile:(NSString*)name;
- (NSString*)readDAOMFile:(NSString*)name;
- (void)setDataBaseSurffixPath:(NSString*)dbSurffixPath;
- (void)setCodefileRootPath:(NSString*)path;
- (void)updateAuthor:(NSString*)author;
- (void)updateProjectName:(NSString*)projectName;
- (NSString*)previewModelHFile:(SQLiteTable*)table;
- (NSString*)previewModelMFile:(SQLiteTable*)table;
- (NSString*)previewDAOHFile:(SQLiteTable*)table;
- (NSString*)previewDAOMFile:(SQLiteTable*)table;
@end
