//
//  SQLiteManagerTemplateLoader.h
//  XXXARC
//
//  Created by @iosxtools on Twitter 9/4/13.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//
#import "CodeTemplateLoader.h"
#import <Foundation/Foundation.h>
typedef enum {
    SQLiteManagerCodeModelHTemplate = 1,
    SQLiteManagerCodeModelMTemplate  = 2 ,
    SQLiteManagerCodeFMDBDaoHTemplate  = 3 ,
    SQLiteManagerCodeFMDBDaoMTemplate  = 4,
    SQLiteManagerCodeSQLiteDaoHTemplate  = 5 ,
    SQLiteManagerCodeSQLiteDaoMTemplate  = 6
}SQLiteManagerCodeTemplateType;
@interface SQLiteManagerTemplateLoader : CodeTemplateLoader
+ (SQLiteManagerTemplateLoader*)sharedInstance;
@property(nonatomic,strong)NSString *templateName;
- (NSString*)defaultTemplateBasePath;
- (NSArray*)defaultTemplats;
- (BOOL)isSystemTemplate:(NSString*)templateName;
- (NSString*)templateUserBasePath;
- (void)changeTemplateBasePath:(NSString*)path;
- (void)changeTemplateTo:(NSString*)templateName;
- (NSString*)loadTemplateWithType:(SQLiteManagerCodeTemplateType)tempType;

- (NSString*)modelHTemplate;
- (NSString*)modelMTemplate;
- (NSString*)daoHTemplate;
- (NSString*)daoMTemplate;

- (NSString*)modelHRelativeFilePath;
- (NSString*)modelMRelativeFilePath;
- (NSString*)daoHRelativeFilePath;
- (NSString*)daoMRelativeFilePath;

- (NSString*)modelHFullFilePath;
- (NSString*)modelMFullFilePath;
- (NSString*)daoHFullFilePath;
- (NSString*)daoMFullFilePath;
@end
