//
//  HTTPClient.h
//  iOSXHttpClient
//
//  Created by @iosxtools on Twitter on on 5/22/13.
//  Copyright (c) 2013 Suning. All rights reserved.
//

#import "HTTPRequestOperation.h"
@interface HTTPClient : AFHTTPClient
- (id)initWithBaseStringURL:(NSString *)url;
- (id)initWithBaseNSURL:(NSURL *)url;

- (id)initWithBaseStringURL:(NSString *)url accept:(NSString*)accept;
- (id)initWithBaseNSURL:(NSURL *)url accept:(NSString*)accept;

- (HTTPRequestOperation *)executeQuery:(HTTPQuery *)query completionBlock:(void (^)(HTTPRequestOperation *, id, NSError *))block;
- (AFHTTPRequestOperation *)executeImageQuery:(HTTPQuery *)query completionBlock:(void (^)(AFHTTPRequestOperation *, id, NSError *))block;
+ (NSString *)HTTPMethod:(HTTPQueryMethod)method;
+ (HTTPQueryMethod)HTTPMethodEnum:(NSString*)method;
@end
