//
//  NSManagedObjectContext+Fetch.h
//  CoreDataMacTest
//
//  Created by @iosxtools on Twitter 7/15/13.
//  Copyright (c) 2013 dsgfdfg. All rights reserved.
//

#import <CoreData/CoreData.h>

@interface NSManagedObjectContext (Fetch)

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                             predicateString:(NSString *)predicateString;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                     sortAttributeName:(NSString *)attributeName
                             ascending:(BOOL)ascending
                       predicateString:(NSString *)predicateString;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                       sortDescriptors:(NSArray *)sortDescriptors
                       predicateString:(NSString *)predicateString;


- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                            attributes:(NSDictionary *)attributes;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                     sortAttributeName:(NSString *)attributeName
                             ascending:(BOOL)ascending
                            attributes:(NSDictionary *)attributes;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                       sortDescriptors:(NSArray *)sortDescriptors
                            attributes:(NSDictionary *)attributes;


- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                            predicate:(NSPredicate *)predicate;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                       predicateFormat:(NSString *)predicateFormat, ...;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                            sortAttributeName:(NSString *)attributeName
                            ascending:(BOOL)ascending;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                             sortDescriptors:(NSArray *)sortDescriptors
                            predicate:(NSPredicate *)predicate;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                            sortAttributeName:(NSString *)attributeName
                            ascending:(BOOL)ascending
                            predicate:(NSPredicate *)predicate;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                     sortAttributeName:(NSString *)attributeName
                             ascending:(BOOL)ascending
                   predicateFormat:(NSString *)predicateFormat, ...;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName
                       sortDescriptors:(NSArray *)sortDescriptors
                       predicateFormat:(NSString *)predicateFormat, ...;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName top:(NSInteger)top;

- (NSArray *)fetchObjectsForEntityName:(NSString *)entityName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;

- (NSArray *)fetchObjectsForRequest:(NSFetchRequest *)request pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;

- (NSArray *)fetchObjectsForRequest:(NSFetchRequest *)request;



- (void)deleteEntity:(NSManagedObject *)entity;

- (void)deleteEntities:(id)objects;

- (void)deleteObjectsForEntityName:(NSString*)entityName;

- (void)deleteObjectsForEntityName:(NSString*)entityName
                         predicate:(NSPredicate *)predicate;

- (void)deleteObjectsForEntityName:(NSString*)entityName
                   predicateFormat:(NSString *)predicateFormat, ...;


- (BOOL)saveContext;

@end
