//
//  XXXCoreDataObjectContext.h
//  XXXOSXCoreDataLib
//
//  by @iosxtools on Twitter on 14-4-25.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XXXCoreDataConstant.h"
@class EntityModel;
@interface XXXCoreDataObjectContext : NSObject
@property(nonatomic,assign)  CoreDataSourceType    sourceType;
@property(nonatomic,readonly) NSArray  *entities;
@property(nonatomic,readonly) NSMutableArray  *entityNames;
@property(nonatomic,readonly) NSString        *modelName;
@property(nonatomic,readonly) NSString        *modelPath;
@property(nonatomic,readonly) NSString        *modelURL;
- (id)initWithModelURL:(NSString*)modelURL;
- (void)refresh;
- (EntityModel*)entityWithName:(NSString*)entityName;
- (NSArray*)entitiesWithEntityItems:(NSArray*)entityItems;
- (NSArray*)entitiesWithIndexes:(NSIndexSet*)indexes;
- (NSArray*)entityData:(NSString*)entityName atIndexes:(NSIndexSet*)indexes;
- (NSArray*)entityData:(NSString*)entityName atIndexes:(NSIndexSet*)indexes ignoreID:(BOOL)ignoreID;

- (NSArray*)entityData:(NSString*)entityName;
- (NSArray*)entityData:(NSString*)entityName ignoreID:(BOOL)ignoreID;

- (NSArray*)entityData:(NSString*)entityName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;

- (NSArray*)entityData:(NSString*)entityName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize ignoreID:(BOOL)ignoreID;

- (NSArray*)entityData:(NSString*)entityName pageOffset:(NSInteger)pageOffset pageSize:(NSInteger)pageSize ignoreID:(BOOL)ignoreID;


- (NSInteger)rowNumWithEntityName:(NSString*)entityName predicate:(NSString*)predicate;

- (NSInteger)indexOfEntity:(id)entityModel;


- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate ignoreID:(BOOL)ignoreID;

- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;

- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize ignoreID:(BOOL)ignoreID;

- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate atIndexes:(NSIndexSet*)indexes error:(NSError**)error;

- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate atIndexes:(NSIndexSet*)indexes ignoreID:(BOOL)ignoreID error:(NSError**)error;

- (NSArray*)entityQueryData:(NSString*)entityName predicate:(NSString*)predicate pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize ignoreID:(BOOL)ignoreID error:(NSError**)error;



- (BOOL)addDataWithEntity:(NSString*)entityName data:(id)data;
- (BOOL)addDataWithEntity:(NSString*)entityName data:(id)data error:(NSError**)error;
- (BOOL)updateDataWithEntity:(NSString*)entityName data:(id)data;
- (BOOL)removeDataWithEntity:(NSString*)entityName data:(id)data;
- (BOOL)emptyEntity:(NSString *)entityName;
- (BOOL)magicEntity:(NSString *)entityName nums:(NSInteger)nums;

//page controll
- (XXXTablePageControll*)entityControllWithName:(NSString*)entityName;
- (void)resetPageControllWithName:(NSString*)entityName;
- (void)resetAllPageControll;
- (XXXTablePageControll*)entityControllWithName:(NSString*)entityName predicate:(NSString*)predicate;
- (void)resetPagePredicateControllWithName:(NSString*)predicate;
- (void)resetAllPagePredicateControll;

//import
- (BOOL)importDataWithEntity:(NSString*)entityName data:(id)data;
- (BOOL)importDataWithEntity:(NSString*)entityName data:(id)data error:(NSError**)error;
@end
