//
//  XXXProbeTypeDefine.h
//  XXXProbeOSX
//
//  by @iosxtools on Twitter on 14-4-22.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//



#define  SQLiteHTTPServiceCodeBase  0

typedef NS_ENUM (NSInteger,SQLiteHTTPServiceType)
{
    
    SQLiteDataBaseListType            =       SQLiteHTTPServiceCodeBase+1,
    SQLiteDataBaseTablesType          =       SQLiteHTTPServiceCodeBase+2,
    SQLiteDataBaseTableType           =       SQLiteHTTPServiceCodeBase+3,
    SQLiteDataBaseSQLType             =       SQLiteHTTPServiceCodeBase+4,
    SQLiteDeviceService               =       SQLiteHTTPServiceCodeBase+5
    
};

#define  SQLiteDataBaseTypeValid(type)  ((type>=SQLiteDataBaseListType && type<=SQLiteDeviceService))


#define  CoreDataHTTPServiceCodeBase  100
typedef NS_ENUM (NSInteger,CoreDataHTTPServiceType)
{
    
    CoreDataModelsType                =       CoreDataHTTPServiceCodeBase+1,
    CoreDataEntitiesType              =       CoreDataHTTPServiceCodeBase+2,
    CoreDataFetchType                 =       CoreDataHTTPServiceCodeBase+3,
    CoreDataCURDType                  =       CoreDataHTTPServiceCodeBase+4,
    CoreDataDataCountType             =       CoreDataHTTPServiceCodeBase+5,
    CoreDataDeviceService             =       CoreDataHTTPServiceCodeBase+6
    
};
#define  CoreDataTypeValid(type)  ((type>=CoreDataModelsType && type<=CoreDataDeviceService))


#define  kCoreData_OP_ClearAll      @"ClearAll"
#define  kCoreData_OP_Add           @"Add"
#define  kCoreData_OP_Remove        @"Remove"
#define  kCoreData_OP_Update        @"Update"
#define  kCoreData_OP_Magic         @"Magic"


#define  OP_Query                   @"Query"
#define  OP_Add                     @"Add"
#define  OP_Remove                  @"Remove"
#define  OP_Update                  @"Update"
#define  OP_Import                  @"Import"


#define  kProbeViewHierarchy         1
#define  kProbeScreenshot            2
#define  kProbeAppVersion            3
#define  kProbeRemoteControll        4
#define  kProbeNotifySend            5
#define  kProbeRecordScreen          6


#define  ProbeCommonHTTPServiceCodeBase  200
typedef NS_ENUM (NSInteger,ProbeCommonHTTPServiceType)
{
    
    ProbeCommonUserDefaultsType                =       ProbeCommonHTTPServiceCodeBase+1,
    ProbeCommonKeyChainType                =       ProbeCommonHTTPServiceCodeBase+2,
    ProbeCommonDocumentsType                =       ProbeCommonHTTPServiceCodeBase+3,
    ProbeCommonNotificationType              =       ProbeCommonHTTPServiceCodeBase+4,
    ProbeCommonHTTPNetworkType              =       ProbeCommonHTTPServiceCodeBase+5,
    ProbeCommonViewHierarchyType              =       ProbeCommonHTTPServiceCodeBase+6,
    ProbeCommonPushTokenType              =       ProbeCommonHTTPServiceCodeBase+7,
    
    
};
#define  ProbeCommonTypeValid(type)  ((type>=ProbeCommonUserDefaultsType && type<=ProbeCommonPushTokenType))



typedef NS_ENUM (NSInteger,XXXProbeType)
{
    XXXProbeUnknownType               =       0,
    XXXProbeCommonType                =       1,
    XXXProbeSQLiteType                =       2,
    XXXProbeCoreDataType              =       4,
    XXXProbeAdminType                 =       8
    
};


#define  AdminHTTPServiceCodeBase  10000

typedef NS_ENUM (NSInteger,AdminHTTPServiceType)
{
    AdminHTTPServiceInterfaceType     =       AdminHTTPServiceCodeBase+1,
    AdminHTTPServicePingType          =       AdminHTTPServiceCodeBase+2,
};

typedef NS_ENUM (NSInteger,HTTPServiceInterfaceType)
{
    HTTPSQLiteServiceInterfaceType               =       1,
    HTTPCoreDataServiceInterfaceType             =       2,
    HTTPProbeServiceInterfaceType                =       4
};
#define  AdminHTTPServiceTypeValid(type)  ((type>=AdminHTTPServiceInterfaceType && type<=AdminHTTPServicePingType))




#ifndef  kSQLiteProbeAPIBaseURL

/*#define  kSQLiteProbeAPIBaseURL          @"/probe/sqlite"
 #define  kSQLiteProbeDataBasePath        @"/probe/sqlite/database"
 #define  kSQLiteProbeDataBaseTablesPath  @"/probe/sqlite/database/tables"
 #define  kSQLiteProbeDataBaseTablePath   @"/probe/sqlite/database/table"
 #define  kSQLiteProbeSQLExecutePath      @"/probe/sqlite/database/sql"
 */


#define  kSQLiteProbeAPIBaseURL          @"/probe/sqlite"
#define  kSQLiteProbeDataBasePath        XXXIntToStr(SQLiteDataBaseListType)
#define  kSQLiteProbeDataBaseTablesPath  XXXIntToStr(SQLiteDataBaseTablesType)
#define  kSQLiteProbeDataBaseTablePath   XXXIntToStr(SQLiteDataBaseTableType)
#define  kSQLiteProbeSQLExecutePath      XXXIntToStr(SQLiteDataBaseSQLType)
#define  kSQLiteDeviceServicePath        XXXIntToStr(SQLiteDeviceService)
#define  kProbeUserDefaultsPath          XXXIntToStr(ProbeCommonUserDefaultsType)
#define  kProbeKeyChainPath          XXXIntToStr(ProbeCommonKeyChainType)
#define  kProbeDocumentsPath          XXXIntToStr(ProbeCommonDocumentsType)
#define  kProbeNotificationPath          XXXIntToStr(ProbeCommonNotificationType)
#define  kProbeHTTPNetworkPath          XXXIntToStr(ProbeCommonHTTPNetworkType)
#define  kProbeViewHierarchyPath          XXXIntToStr(ProbeCommonViewHierarchyType)
#define  kProbePushTokenPath          XXXIntToStr(ProbeCommonPushTokenType)


#define  kCoreDataProbeModelsPath        XXXIntToStr(CoreDataModelsType)
#define  kCoreDataProbeEntitesPath       XXXIntToStr(CoreDataEntitiesType)
#define  kCoreDataProbeFetchPath         XXXIntToStr(CoreDataFetchType)
#define  kCoreDataProbeGURDPath          XXXIntToStr(CoreDataCURDType)
#define  kCoreDataProbeDataCountPath     XXXIntToStr(CoreDataDataCountType)
#define  kCoreDataDeviceServicePath      XXXIntToStr(CoreDataDeviceService)



#define  kAdminHTTPServiceInterfacePath   XXXIntToStr(AdminHTTPServiceInterfaceType)




#endif


