//
//  SQLiteChannel.h
//  XXXARC
//
//  Created by @iosxtools on Twitter on on 9/1/13.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//

#import <Foundation/Foundation.h>
@class SQLiteDataBase,SQLiteTable,SQLiteQueryTable;
@interface SQLiteChannel : NSObject
@property(nonatomic,strong)FMDatabase *db;
@property(nonatomic,copy)NSString       *dbName;
@property(nonatomic,copy)NSString       *dbPath;
@property(nonatomic,copy)NSString       *hostURLString;
- (id)initWithDbPath:(NSString*)path;
- (BOOL)openDataBase;
- (void)closeDataBase;
- (BOOL)createDataBase:(NSString*)dbPath;
- (BOOL)mergeDataBaseFrom:(SQLiteChannel*)channel includeData:(BOOL)includeData;
- (BOOL)emptyAllTable;
- (BOOL)dropAllTable;
- (NSArray*)tables;
- (SQLiteTable*)tableWithName:(NSString*)tableName;
- (SQLiteQueryTable*)tableQueryWithSQL:(NSString*)sql error:(NSError**)error;
- (void)refreshTableWithName:(NSString*)tableName;
- (void)refreshTable:(SQLiteTable*)table;
- (void)channeledSQLiteDataBase;
- (NSArray*)tableData:(SQLiteTable*)table;
- (NSArray*)tableData:(SQLiteTable*)table ignoreRowID:(BOOL)ignoreRowID;
- (NSArray*)tableDataWithSQL:(NSString*)sql;
- (NSArray*)tableCSVData:(SQLiteTable*)table;
- (NSArray*)tableData:(SQLiteTable*)table pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;
- (NSArray*)tableData:(SQLiteTable*)table pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize ignoreRowID:(BOOL)ignoreRowID;
- (NSArray*)tableData:(SQLiteTable*)table pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize filter:(NSString*)filter;
- (NSArray*)tableData:(SQLiteTable*)table pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize filter:(NSString*)filter ignoreRowID:(BOOL)ignoreRowID;
- (NSArray*)tableDataWithSQL:(NSString*)sql pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;


- (void)magicData:(NSString *)tableName nums:(int)nums;
- (NSInteger)rowNumWithTableName:(NSString*)tableName;
- (NSInteger)rowNumWithSQL:(NSString*)sql;
- (BOOL)updataDataWithTable:(NSString*)tableName data:(NSMutableDictionary*)data;
- (BOOL)removeDataWithTable:(NSString*)tableName data:(id)data;
- (BOOL)emptyTable:(NSString *)tableName;
/*DDL*/
- (BOOL)dropTable:(NSString*)tableName;
- (BOOL)createTable:(NSString*)sql;
- (BOOL)alterTable:(NSString*)sql;
- (BOOL)executeUpdate:(NSString*)sql;
- (BOOL)executeUpdate:(NSString*)sql error:(NSError**)error;
/*Data Import*/
- (BOOL)importData2Table:(SQLiteTable*)table data:(id)data;
- (BOOL)importData2Table:(SQLiteTable*)table data:(id)data error:(NSError**)error;

@end
