//
//  SQLiteDataBase.h
//  XXXARC
//
//  Created by @iosxtools on Twitter on on 9/1/13.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SQLiteDataBaseItem.h"
@class SQLiteTable,SQLiteColumn,XXXTablePageControll,SQLiteQueryTable,XXXPageManager;
@interface SQLiteDataBase : NSObject
@property(nonatomic,assign)SQLiteDataBaseSourceType    sourceType;
@property(nonatomic,strong) NSMutableArray *tables;
@property(nonatomic,strong) NSMutableDictionary *tablesNameMap;
@property(nonatomic,strong) NSMutableArray *tableNames;
@property(nonatomic,copy) NSString    *dbName;
@property(nonatomic,copy) NSString    *dbPath;
@property(nonatomic,copy) NSString    *url;
@property(nonatomic,strong) NSMutableDictionary *tablePageManagerCache;
@property(nonatomic,strong) NSMutableDictionary *tableSQLQueryCache;
- (id)initWithDataBaseName:(NSString*)dbName;
- (id)initWithURLPath:(NSString*)url;
- (void)closeDataBase;
- (void)addTables:(id)tables;
- (void)removeTables:(id)tables;
- (void)refresh;
- (void)refreshTableWithName:(NSString*)tableName;
- (void)refreshTable:(SQLiteTable*)table;
- (BOOL)containsTable:(SQLiteTable*)table;
- (SQLiteTable*)tableWithName:(NSString*)tableName;
- (NSArray*)tablesWithNames:(NSArray*)tableNames;
- (NSArray*)tablesAtIndexes:(NSIndexSet *)indexes;
- (NSArray*)tablesWithTableItems:(NSArray*)tableItems;
- (SQLiteQueryTable*)tableQueryWithSQL:(NSString*)sql error:(NSError**)error;

- (NSArray*)tableData:(id)table;
- (NSArray*)tableData:(id)table ignoreRowID:(BOOL)ignoreRowID;
- (NSArray*)tableCSVData:(id)table;

- (NSArray*)tableData:(NSString*)tableName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;
- (NSArray*)tableData:(NSString*)tableName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize ignoreRowID:(BOOL)ignoreRowID;

- (NSArray*)tableData:(NSString*)tableName atIndexes:(NSIndexSet *)indexes;
- (NSArray*)tableData:(NSString*)tableName atIndexes:(NSIndexSet *)indexes ignoreRowID:(BOOL)ignoreRowID;

- (NSArray*)tableData:(NSString*)tableName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize filter:(NSString*)filter;
- (NSArray*)tableData:(NSString*)tableName pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize filter:(NSString*)filter ignoreRowID:(BOOL)ignoreRowID;

- (NSArray*)tableSQLData:(NSString*)sql pageIndex:(NSInteger)pageIndex pageSize:(NSInteger)pageSize;

- (NSArray*)tableSQLData:(NSString*)sql;
- (NSArray*)tableSQLData:(NSString*)tableName atIndexes:(NSIndexSet *)indexes;

- (void)magicData:(NSString *)tableName nums:(int)nums;
- (NSInteger)rowNumWithTableName:(NSString*)tableName;
- (NSInteger)rowNumWithSQL:(NSString*)sql;

- (BOOL)updataDataWithTable:(NSString*)tableName data:(NSMutableDictionary*)data;
- (BOOL)removeDataWithTable:(NSString*)tableName data:(id)data;
- (BOOL)emptyTable:(NSString *)tableName;
- (NSInteger)indexOfSQLiteTable:(id)tableID;
/*Page Controll*/
- (XXXTablePageControll*)tableControllWithName:(NSString*)tableName;
- (XXXPageManager*)tablePageManagerWithName:(NSString*)tableName;
- (void)resetPageControllWithName:(NSString*)tableName;
/*SQL Controll*/
- (XXXTablePageControll*)tableSQLQueryWithSQLString:(NSString*)sql;
- (void)resetSQLQueryControllWithName:(NSString*)tableName;
/*DDL*/
- (BOOL)executeUpdate:(NSString*)sql;
- (BOOL)dropTable:(NSString*)tableName;
- (BOOL)createTable:(SQLiteTable*)table;
- (BOOL)createDataBase:(NSString*)dbPath;
- (BOOL)mergeDataBaseFrom:(SQLiteDataBase*)dataBase includeData:(BOOL)includeData;
- (BOOL)emptyAllTable;
- (BOOL)dropAllTable;
- (BOOL)createTableWithSQLString:(NSString*)sql;
- (BOOL)arrangeTableColumns:(SQLiteTable*)table;
- (BOOL)renameTable:(NSString*)tableName tableNewName:(NSString*)tableNewName;
- (BOOL)duplicateTable:(NSString*)tableName tableNewName:(NSString*)tableNewName;
- (BOOL)removeTableColumns:(NSIndexSet*)indexes tableName:(NSString*)tableName;
- (BOOL)addTableColumn:(SQLiteColumn*)column tableName:(NSString*)tableName;
- (BOOL)updateTableColumnDefine:(SQLiteTable*)table;
/**/
- (BOOL)importData2Table:(SQLiteTable*)table data:(id)data;
- (BOOL)importData2Table:(SQLiteTable*)table data:(id)data error:(NSError**)error;
- (BOOL)importData2TableWithName:(NSString*)tableName data:(id)data;
- (BOOL)importData2TableWithName:(NSString*)tableName data:(id)data error:(NSError**)error;
/*Imprt*/
- (BOOL)importSQLAtPath:(id)paths error:(NSError**)error;
- (BOOL)importSQL:(NSString*)sql error:(NSError**)error;
@end
