//
//  SQLiteHandler.h
//  XXXSQLiteLib
//
//  by @iosxtools on Twitter on 1/5/14.
//  Copyright (c) 2014 http://www.iosxtools.com. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SQLiteHandler : NSObject
@property(nonatomic,strong)NSString *dbPath;
@property(nonatomic,strong)NSString *lastErrorMessage;
@property(nonatomic,assign)long lastErrorCode;
@property(nonatomic,assign)long long lastInsertRowId;
- (id)initWithDbPath:(NSString*)path;
- (BOOL)openDataBase;
- (void)closeDataBase;
- (BOOL)createDataBase:(NSString*)dbPath;
- (id)executeQuery:(NSString*)sql;
- (BOOL)executeUpdate:(NSString*)sql;
- (BOOL)hasError;
- (void)clearError;
- (NSError*)currentError;
- (id)serviceQueryAllTables;
- (id)serviceRefreshTable:(NSString*)tableName;
@end
