//
//  SQLiteTable.h
//  XXXARC
//
//  Created by @iosxtools on Twitter on on 9/1/13.
//  Copyright (c) http://www.iosxtools.com All rights reserved.
//

#import <Foundation/Foundation.h>
@class SQLiteColumn;
@interface SQLiteTable : NSObject
@property(nonatomic,strong)NSString *name;
@property(nonatomic,strong)NSMutableArray *columns;
@property(nonatomic,strong)NSMutableArray *keys;
@property(nonatomic,strong)NSArray *columnsExcludeKeys;
@property(nonatomic,strong)NSString *stateSQLString;
@property(nonatomic,strong)NSString *filter;
@property(nonatomic,assign)NSInteger rowNums;
@property(nonatomic,strong)NSString *insertSQLString;
@property(nonatomic,strong)NSString *updateSQLString;
@property(nonatomic,strong)NSString *deleteSQLString;
@property(nonatomic,strong)NSString *keySQLString;
- (id)initWithName:(NSString *)name ;
- (void)addColumn:(SQLiteColumn*)col;
- (void)addColumns:(id)cols;
- (void)addColumnsWithDictionary:(NSDictionary *)meta;
- (void)updateColumns:(id)cols;
- (void)removeColumns:(id)cols;
- (void)removeKeyColumnWithName:(NSString*)colName;
- (void)removeKeyColumn:(SQLiteColumn*)col;
- (BOOL)containsColumn:(SQLiteColumn*)column;
- (SQLiteColumn*)columnWithName:(NSString*)colName;
- (void)removeColumnWithName:(NSString*)colName;
- (void)clearFilter;
- (NSString*)insertSQLColsString;
- (NSDictionary*)objectAsDictionary;
- (id)initWithDictionary:(NSDictionary *)dictionary;
@end
