#!/usr/bin/env perl

use strict;

sub rot13
{
	my $st = shift;

	$st =~ tr/A-Za-z/N-ZA-Mn-za-m/;

	return $st;
}

sub prepareItems
{
	my @ar = split(/\./,shift);

	my $res = '';
	foreach my $item (@ar)
	{
		$res .= "enRot13(\@\"$item\"),";
	}
	return $res;
}

my $info = `cat DrawDemoInfo.plist`;

print "// This file was automatically generated by fetchBID.pl based on DrawDemoInfo.plist settings\n// See target's Build Phases for details\n\n";
print "// $1\n\tbundleIdentifier = enRot13(\@\"" . rot13($1) . "\");\n" if ($info =~ /<key>CFBundleIdentifier<\/key>\s*<string>(.+?)<\/string>/);
print "// $1\n\tbundleVersion = [[NSArray arrayWithObjects:" . prepareItems($1) . "nil] componentsJoinedByString:@\".\"];\n"	if ($info =~ /<key>CFBundleShortVersionString<\/key>\s*<string>(.+?)<\/string>/);

