//
//  AccountFormatter.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2008-08-29.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#else
#import <Cocoa/Cocoa.h>
#endif
//
// Starting with version 5.0, all account numbers are stored in 8 digits.
// If only 4 are used, the most significant digits are used first.
//

enum ASAccountNumberSortingStyle {
    kASAccountNumberSortingDefault,
    kASAccountNumberSortingSwiss
};

@interface AccountFormatter : NSNumberFormatter {
    enum ASAccountNumberSortingStyle sortingStyle;
}
@property (assign) enum ASAccountNumberSortingStyle sortingStyle;
@property (strong) NSString *baseAccountFormat;
@property (strong) NSString * (^toString)(NSInteger k);
@property (strong) NSInteger (^fromString)(NSString *s);

+ (NSString *)defaultFormat;
+ (NSString *)formatDefaultsKey;
+ (AccountFormatter *)sharedAccountFormatter;

+ (void)setDefaultSortingStyle:(enum ASAccountNumberSortingStyle)style format:(NSString *)format;

- (void)setAccountFormat:(NSString *)format;
- (NSString *)accountFormat;

+ (enum ASAccountNumberSortingStyle)sortingStyle;
- (NSComparisonResult)compareAccountNumber:(NSNumber *)n1 withAccountNumber:(NSNumber *)n2;

+ (NSString *)sortingStyleDefaultsKey;
@end
