//
//  Article.h
//  EconomacsSDK
//
//  Created by Erik Aderstedt on 2008-04-28.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//
//	The Article entity encapsulates an article (product). Apart from the expected, exposed
//	fields, there are also fields for 'unit' (e.g. 'pcs', 'kg', 'm') and two fields for
//	'dependent tax'. Dependent tax articles have names like 'Reklamskatt 16%', which is automatically
//	parsed and the level (16%) stored in the dependentTaxLevel attribute. Whenever such an
//	article is added to an invoice, its price is calculated by applying the tax rate to the preceding
//	article. This feature is not documented at the user level, and as far as I know only a single user
//	uses it (in Sweden). The preceding text ('Reklamskatt') is language dependent.
// 
//	Please note that the salesAccount relationship is uni-directional.
//	Also, the vat level is in percent (i.e. '25' for 25%, NOT 0.25).
//
//	The number attribute is an NSString to support article numbers like '25A'. To improve
//	sorting in these cases, we provide a different comparison method that allows us to
//	perform string comparison with the NSNumericSearch option.

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

enum articleTypes {
	AS_PTYP_GOOD = 'PtyG',
	AS_PTYP_SERVICE = 'PtyS'
};

@class Account;

@interface Article : NSManagedObject {

}

@property(retain) NSNumber *isDependentTax;
@property(retain) NSNumber *dependentTaxLevel;
@property(retain) NSString *name;
@property(retain) NSString *number;
@property(retain) NSNumber *isFreeTextProduct;
@property(retain) NSNumber *type;
@property(retain) NSString *unit;
@property(retain) NSDecimalNumber *price;
@property(retain) NSSet *invoiceLines;
@property(retain) Account *salesAccount;

- (void)setPropertiesFromLatestArticle;

- (NSString *)typeName;
- (void)setTypeName:(NSString *)t;

- (NSString *)numberAndNameDescription;
- (NSComparisonResult)compareNumber:(Article *)otherArticle;

// Hard-coded VAT rates, used to provide different default VAT rates in different countries.
+ (NSDecimalNumber *)vatRateForCountry:(NSString *)country;
+ (NSDecimalNumber *)reducedVatRateForCountry:(NSString *)country;
+ (NSDecimalNumber *)furtherReducedVatRateForCountry:(NSString *)country;

+ (Article *)defaultArticleInContext:(NSManagedObjectContext *)moc;
- (NSNumber *)isUsed;

- (NSDecimalNumber *)vat;
- (Account *)vatAccount;

@end
