//
//  Entry.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2007-10-30.
//  Copyright 2007 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <UIKit/UIKit.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class FiscalYear;
@class Account;

#define SIE_MISSING_NUMBER_NO	2147383647

#define AS_ET_UNKNOWN
#define AS_ET_RECEIVED_SUPPLIER_INVOICE 1
#define AS_ET_PAID_SUPPLIER_INVOICE 2

enum ASEntryType {
    kASEntryTypeUnknown = 0,
    kASEntryTypeSent,
    kASEntryTypePartiallyPaid,
    kASEntryTypePaid,
    kASEntryTypeReminder,
    kASEntryTypeLoss
};

extern NSString *ASABFiledEntriesNotificationName;
extern NSString *ASABFiledEntriesKey;
extern NSString *ASABViewSnapshotDataKey;

@class Invoice;
@class SupplierInvoice;

@interface Entry : NSManagedObject <NSCopying>{

}

@property(retain) NSString      *name;
@property(retain) NSNumber      *number;
@property(retain) NSString      *comments;
#if defined(IFAKTURA)
@property(retain) UIImage       *image;
#endif
@property(retain) NSNumber      *date;
@property(retain) NSNumber		*vatDate;
@property(retain) NSNumber      *registryDate;
@property(retain) NSNumber      *type;
@property(retain) FiscalYear    *fiscalYear;
@property(retain) NSSet         *rows;
@property(retain) NSString      *vatno;
@property(retain) NSString      *statement;

- (void)setInvoice:(Invoice *)invoice entryType:(enum ASEntryType)entryType;
- (void)setSupplierInvoice:(SupplierInvoice *)invoice entryType:(enum ASEntryType)entryType;

- (NSString *)entryDescription;
- (NSDictionary *)contents;
- (NSString *)numberAsString;
- (NSString *)dateString;
- (NSArray *)orderedRows;
- (NSDecimalNumber *)turnover; /* Omslutning */
+ (NSNumber *)nextEntryNumberForDate:(NSNumber *)number inContext:(NSManagedObjectContext *)context;
- (BOOL)isBalanced;
- (BOOL)hasVatFreeSalesRow;

- (void)copyRowsFromOtherEntry:(Entry *)otherEntry;
- (void)removeEmptyRows;

- (BOOL)checkValidation:(NSError **)error;

- (NSArray *)accrueWithAccount:(Account *)account startMonth:(NSNumber *)startMonth endMonth:(NSNumber *)endMonth;
- (NSArray *)fileMe:(NSError **)error;
- (NSArray *)fileMe:(NSError **)error toUpcoming:(BOOL)toUpcoming;
- (NSArray *)fileMe:(NSError **)error toUpcoming:(BOOL)toUpcoming postNotification:(BOOL)postIt;
- (void)clear;

- (NSArray *)matchingAmounts;
- (NSArray *)matchingTags;
- (NSString *)textualRepresentation;
- (BOOL)hasTrackedChanges;

- (BOOL)validateRows:(id *)ioValues error:(NSError **)outError;
- (BOOL)validateDate:(id *)n error:(NSError **)e;
+ (NSNumber *)dateOfLatestFiledEntryInContext:(NSManagedObjectContext *)context;

@end
