//
//  InvoiceLine.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2008-04-28.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Article;
@class Invoice;

@interface InvoiceLine : NSManagedObject {

}

@property(retain) NSNumber *number;
@property(retain) NSDecimalNumber *quantity;
@property(retain) NSDecimalNumber *price;
@property(retain) NSDecimalNumber *vat;
@property(retain) NSString *comment;
@property(nonatomic,retain) NSString *discountString;
@property(retain) Article *article;
@property(retain) Invoice *invoice;
@property(retain) NSString *unit;
@property(nonatomic,retain) NSDecimalNumber *discountRelative;
@property(nonatomic,retain) NSDecimalNumber *discountAbsolute;

@property(nonatomic,retain) NSString *articleNumber;
@property(nonatomic,retain) NSString *articleName;

@property(retain) NSDecimalNumber *c_amountExclVat;
@property(retain) NSDecimalNumber *c_vatAmount;
@property(retain) NSDecimalNumber *cl_amountExclVat;
@property(retain) NSDecimalNumber *cl_vatAmount;

- (void)handleChangedArticle;

- (NSDecimalNumber *)amountExclVat;
- (NSDecimalNumber *)vatAmount;
- (NSDecimalNumber *)amountInclVat; 
- (NSDecimalNumber *)localAmount;

- (void)inscribeAmounts;

- (NSDecimalNumber *)priceInclVat;
- (void)setPriceInclVat:(NSDecimalNumber *)p;
- (NSDecimalNumber *)rawVat;

- (InvoiceLine *)duplicate;

@end
