//
//  Language.h
//  TemplateEditor
//
//  Created by Erik Aderstedt on 2010-07-04.
//  Copyright 2010 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#import <Quartz/Quartz.h>
#endif

@class Template;
@class Invoice;

@interface Language : NSManagedObject {
}
@property (strong) PDFDocument *theDocument;
@property(retain) NSString *code;

+ (Language *)languageVersionInTemplate:(Template *)t forInvoice:(Invoice *)i;

- (PDFDocument *)document;
- (void)setDocument:(PDFDocument *)doc;
- (PDFPage *)page;

- (NSString *)localizedLanguageName;
- (NSArray *)applicableFields;

- (NSString *)stringForKey:(NSString *)key;
- (NSString *)invoice;
- (NSString *)firstReminder;
- (NSString *)secondReminder;
- (NSString *)packingSlip;
- (NSString *)creditInvoice;

+ (NSArray *)allLanguagesInContext:(NSManagedObjectContext *)moc;

@end
