//
//  MoneyFormatter.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2008-07-20.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@interface MoneyFormatter : NSNumberFormatter 

@property(strong) NSNumber *hideDecimals;
@property(strong) NSNumber *hideZeros;
@property(strong) NSNumber *negating;
@property(strong) NSNumberFormatter *regular;
@property(assign) BOOL forcePlusSign;

- (void)setCurrencyCode:(NSString *)currencyCode;

+ (instancetype)localMoneyFormatter;

@end

@interface NSNumberFormatter ( ASNumberFormatter_extensions)

- (void)adjustForShortOrLongAccordingToPreferences;
- (void)adjustPrefixAndSuffixForKrona;

@end

