//
//  NewRow.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2014-06-12.
//  Copyright (c) 2014 Aderstedt Software AB. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>

@class Account, Tag, Row;

@interface NewRow : NSManagedObject

@property (nonatomic, retain) NSDecimalNumber * amount;
@property (nonatomic, retain) Account *account;
@property (nonatomic, retain) Tag *tag;
@property (nonatomic, retain) NSNumber *stricken;
@property (nonatomic, retain) NSNumber *number;
@property (nonatomic, strong) NSManagedObjectID *originalObjectID;
@property (nonatomic, retain) NSNumber *pending;
@property (nonatomic, retain) NSNumber *vatFreeSalesType;
@property (nonatomic, assign) enum ASVatFreeSalesType salesType;
@property (nonatomic, retain) NSNumber *editedEntry;

+ (instancetype)copyRow:(Row *)row intoContext:(NSManagedObjectContext *)moc;
+ (instancetype)copyRow:(Row *)row intoContext:(NSManagedObjectContext *)moc sameBackingStore:(BOOL)sameBacking;

- (void)makeEntryBalanced;

@end
