//
//  StartingBalance.h
//  EconomacsSDK
//
//  Created by Erik Aderstedt on 2008-04-27.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//
//	The StartingBalance entity encapsulates a single value for a starting balance entering
//	a fiscal year. The starting balance is identified by the account and the fiscal year.
//	Note that the balance will typically be negative for liability and equity accounts.
//	
//	Starting balances should only be defined for balance sheet accounts (assets, liabilities / equity).

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Account;
@class FiscalYear;

@interface StartingBalance : NSManagedObject {

}

@property(retain) Account			*account;
@property(retain) NSDecimalNumber	*balance;
@property(retain) FiscalYear		*fiscalYear;

@end
