//
//  Tag.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2008-04-27.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@interface Tag : NSManagedObject {

}

@property(retain) NSNumber *number;
@property(retain) NSString *name;
@property(retain) NSSet *rows;

+ (NSNumber *)newTagNumber;
+ (void)setNewTagNumber:(NSNumber *)n;

+ (Tag *)tagWithNumber:(NSNumber *)tagNo inContext:(NSManagedObjectContext *)moc;
+ (void)removeEmptyTagsInContext:(NSManagedObjectContext *)moc;

// The tags are typically used for result sheet accounts.
- (NSDecimalNumber *)balance;
- (NSString *)tagDescription;

@end
