//
//  VatPeriod.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2014-11-05.
//  Copyright (c) 2014 Aderstedt Software AB. All rights reserved.
//

#import <CoreData/CoreData.h>

@class Entry;

@interface VatPeriod : NSManagedObject

@property (nonatomic,retain) NSNumber *start;
@property (nonatomic,retain) NSNumber *end;
@property (retain) Entry *entry;
@property (nonatomic,retain) NSNumber *closed;

+ (instancetype)periodForEntryDate:(NSNumber *)d inManagedObjectContext:(NSManagedObjectContext *)context;
+ (instancetype)periodForIntervalStarting:(NSNumber *)s ending:(NSNumber *)e inManagedObjectContext:(NSManagedObjectContext *)context;

- (void)reopen;
- (NSNumber *)dateIndexOfNextOpenPeriod;
+ (instancetype)existingVatPeriodForStartDate:(NSNumber *)s endDate:(NSNumber *)e inContext:(NSManagedObjectContext *)context;
+ (instancetype)newVatPeriodForStartDate:(NSNumber *)s endDate:(NSNumber *)e entry:(Entry *)verifikation;

- (NSString *)periodDescription;

@end
