//
//  ASCoreData_addresses.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2008-10-03.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class ABPerson;

@interface NSManagedObject(ASCoreData_addresses) 

- (NSString *)addressWithCountryIncluded:(BOOL)c;
- (NSString *)addressWithCountryIncluded:(BOOL)c attention:(NSString *)att;	
- (NSAttributedString *)formattedAddressWithCountryIncluded:(BOOL)c;
- (NSAttributedString *)formattedAddressWithCountryIncluded:(BOOL)c attention:(NSString *)att;
- (NSAttributedString *)formattedAddressWithCountryIncluded:(BOOL)c attention:(NSString *)att prefix:(NSString *)prefix;

#if !defined(IFAKTURA)
- (void)assignAddressFromAddressBook:(ABPerson *)person withLabels:(NSArray *)labels;
- (void)assignAddressFromAddressBook:(ABPerson *)person;
- (void)assignPhoneFromAddressBook:(ABPerson *)person;
- (void)assignEmailFromAddressBook:(ABPerson *)person;
#endif

@end
