//
//  ASPluginBase.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2009-02-25.
//  Copyright 2009 Aderstedt Software AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASViewControllerProtocol.h"

enum ASPluginType {
	kASBadPlugin,
	kASMenuActionPlugin,
	kASViewPlugin
};

@interface ASPluginBase : NSObject

@property(nonatomic,strong) NSManagedObjectContext *managedObjectContext;
@property(nonatomic,strong) NSURL *url;

- (id)initWithManagedObjectContext:(NSManagedObjectContext *)_managedObjectContext;

- (NSString *)title;		// Used for the menu item title.
- (enum ASPluginType)type;

@end


@interface ASViewPluginBase : ASPluginBase {
}

- (Class)viewControllerClass;

@end