//
//  Customer.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2014-03-07.
//  Copyright (c) 2014 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif


enum ASABBusinessContactType {
	kASABContactTypeCustomer = 1,
	kASABContactTypeSupplier = 2,
	kASABContactTypeBoth = 3
};

@class Invoice;

@interface BusinessContact : NSManagedObject

@property (nonatomic, retain) NSString * attention;
@property (nonatomic, retain) NSString * city;
@property (nonatomic, retain) NSString * company;
@property (nonatomic, retain) NSString * country;
@property (nonatomic, retain) NSString * county;
@property (nonatomic, retain) NSString * d_attention;
@property (nonatomic, retain) NSString * d_city;
@property (nonatomic, retain) NSString * d_country;
@property (nonatomic, retain) NSString * d_county;
@property (nonatomic, retain) NSString * d_street;
@property (nonatomic, retain) NSString * d_zipcode;
@property (nonatomic, retain) NSString * email;
@property (nonatomic, retain) NSString * name;
@property (nonatomic, retain) NSNumber * number;
@property (nonatomic, retain) NSString * phone;
@property (nonatomic, retain) NSString * mobile;
@property (nonatomic, retain) NSString * web;
@property (nonatomic, retain) NSString * street;
@property (nonatomic, retain) NSString * vatno;
@property (nonatomic, retain) NSString * orgno;
@property (nonatomic, retain) NSString * zipcode;
@property (nonatomic, retain) NSSet *invoices;
@property (nonatomic, retain) NSString *customerDescription;
@property (nonatomic, retain) NSSet *supplierInvoices;
@property (nonatomic, retain) NSNumber * type;
@property (nonatomic, retain) NSNumber *hasDeliveryAddress;

@property (nonatomic, retain) NSNumber *isSupplier;
@property (nonatomic, retain) NSNumber *isCustomer;

- (void)assignNumber;
- (NSArray *)addressArray;

@end

@interface BusinessContact (CoreDataGeneratedAccessors)

- (void)addInvoicesObject:(Invoice *)value;
- (void)removeInvoicesObject:(Invoice *)value;
- (void)addInvoices:(NSSet *)values;
- (void)removeInvoices:(NSSet *)values;

@end
