//
//  Company.h
//  EconomacsSDK
//
//  Created by Erik Aderstedt on 2008-05-05.
//  Copyright 2008 Aderstedt Software AB. All rights reserved.
//
//	The Company entity encapsulates all information relating to the
//	business that the bookkeeping and invoicing relates to. There is
//	a single instance of this entity in a given document context.

#if defined(IFAKTURA)
#import <UIKit/UIKit.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Account;

enum ASABSwedishCompanyForm {
    kASABAktiebolag,
    kASABHandelsbolag,
    kASABEnskildFirma,
    kASABAnnanForm
};

@interface Company : NSManagedObject

@property(nonatomic,retain) NSString *bank;
@property(nonatomic,retain) NSString *bankAccount;
@property(nonatomic,retain) NSString *bic;
@property(nonatomic,retain) NSString *iban;
@property(nonatomic,retain) NSString *paymentOption1;
@property(nonatomic,retain) NSString *paymentOption2;

@property(nonatomic,retain) NSString *orgname;
@property(nonatomic,retain) NSString *street;
@property(nonatomic,retain) NSString *zipcode;
@property(nonatomic,retain) NSString *city;
@property(nonatomic,retain) NSString *county;
@property(nonatomic,retain) NSString *country;

@property(nonatomic,retain) NSString *vatno;
@property(nonatomic,retain) NSString *orgid;

@property(nonatomic,retain) NSString *email;
@property(nonatomic,retain) NSString *fax;
@property(nonatomic,retain) NSString *phone;
@property(nonatomic,retain) NSString *homepage;

@property(nonatomic,retain) NSNumber *registeredForTax; // Means different things in different countries.
@property(nonatomic,retain) NSNumber *registeredForVat;

@property(nonatomic, retain) NSString *currency;
@property(nonatomic, retain) NSNumber *autoBook;
@property(nonatomic, retain) NSNumber *bookOnce;
@property(nonatomic, retain) NSNumber *days;
@property(nonatomic, retain) NSNumber *vatMode;
@property(nonatomic, retain) NSNumber *fieldMask;

@property(nonatomic,retain) Account *results;
@property(nonatomic,retain) Account *accountsPayable;
@property(nonatomic,retain) Account *accountsReceivable;
@property(nonatomic,retain) Account *currencyGains;
@property(nonatomic,retain) Account *currencyLosses;
@property(nonatomic,retain) Account *roundingAccount;
@property(nonatomic,retain) Account *incomeAccount;
@property(nonatomic,retain) Account *irpfAccount;

@property(nonatomic,retain) NSNumber *entryDate;
@property(nonatomic,retain) NSString *entryName;
@property(nonatomic,retain) NSString *entryComment;
@property(nonatomic,retain) NSString *entryVatno;

#if !defined(IFAKTURA)
@property(retain) NSImage	*logotype;
@property(nonatomic,retain) NSImage *entryImage;
#else
@property(retain) UIImage *logotype;
@property(nonatomic,retain) UIImage *entryImage;
#endif

+ (NSArray *)euCountries;
+ (BOOL)outsideEU:(NSString *)countryCode;
- (BOOL)isOutsideEU;

- (enum ASABSwedishCompanyForm)swedishCompanyForm;

+ (Company *)inContext:(NSManagedObjectContext *)moc;
+ (Company *)inContext:(NSManagedObjectContext *)moc create:(BOOL)createIfNeeded;

#if !defined(IFAKTURA)
// AppleScript
- (NSDocument *)theDocument;
#endif

- (NSString *)acceptableSwedishOrganisationNumber;
- (NSString *)countryCodeForReports;
- (NSString *)countryName;
- (NSNumber *)isInSpain;

@end
