//
//  FiscalYear.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2007-10-30.
//  Copyright 2007 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@interface FiscalYear : NSManagedObject {

}

@property(retain) NSNumber *start;
@property(retain) NSNumber *end;
@property(retain) NSString *name;
@property(retain) NSSet *startingBalances;
@property(retain) NSSet *entries;

+ (NSArray *)findFiscalYearsForDateIndex:(NSNumber *)d inContext:(NSManagedObjectContext *)moc;
+ (FiscalYear *)findFiscalYearForDateIndex:(NSNumber *)d inContext:(NSManagedObjectContext *)moc;
+ (FiscalYear *)findFiscalYearForDateIndex:(NSNumber *)d inArray:(NSArray *)fiscalYears;
+ (FiscalYear *)latestFiscalYearInContext:(NSManagedObjectContext *)moc;

- (NSNumber *)isLatest;
- (NSString *)suitableName;
- (FiscalYear *)previous;
- (NSNumber *)dateIndexOfLatestEntry;
- (NSNumber *)highestEntryNumber;

- (NSPredicate *)predicate;
- (NSPredicate *)invoicePredicate;
- (NSPredicate *)invoiceLinePredicate;
- (NSPredicate *)rowPredicate;

- (NSDecimalNumber *)profitLoss;
- (NSDecimalNumber *)profitLossByDateIndex:(NSNumber *)d;
- (NSDecimalNumber *)profitLossIncludingProfitAccount;
- (NSArray *)orderedStartingBalances;

- (void)removeIfEmpty;
- (void)setToYearContaining:(NSDate *)d;
- (BOOL)updateStartingBalances:(NSError **)error;

- (BOOL)containsDateIndex:(NSNumber *)d;
- (BOOL)isCalendarYear:(NSInteger)year;

+ (NSString *)sieDateStringForDateIndex:(NSNumber *)d;
- (NSString *)startDateString;
- (NSString *)endDateString;

+ (NSString *)startDate:(NSNumber **)start andEndDate:(NSNumber **)end forNewFiscalYearInManagedObjectContext:(NSManagedObjectContext *)context;

@end
