//
//  NSManagedObject+ASErrorHandling.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2013-10-24.
//  Copyright (c) 2013 Aderstedt Software AB. All rights reserved.
//

#import <CoreData/CoreData.h>

extern NSString *EconomacsErrorDomain;

#define NO_NUMBER_FOR_ACCOUNT               1
#define DUPLICATE_ACCOUNT_NUMBERS           2
#define ARTICLES_NEED_NAME                  3
#define ARTICLES_NEED_NUMBER                4
#define ARTICLES_NEED_SALES_ACCOUNT         5
#define NO_NEW_ENTRY_FOUND                  6
#define CANNOT_CHANGE_CURRENCY              7
#define NO_APPROPRIATE_FISCAL_YEAR          8
#define MULTIPLE_MATCHING_FISCAL_YEARS      9
#define DATE_NOT_IN_FISCAL_YEAR             10
#define ENTRY_NOT_BALANCED                  11
#define NO_PREVIOUS_FISCAL_YEAR             12
#define SOME_ENTRIES_BEFORE_START           13
#define SOME_ENTRIES_AFTER_START            14
#define END_BEFORE_START                    15
#define OVERLAPPING_FISCAL_YEARS            16
#define NO_ACCOUNTS_RECEIVABLE              17
#define BLANK_INVOICE                       18
#define NO_DEFAULT_PRODUCT                  19
#define COULD_NOT_CREATE_SALES_ENTRY        20
#define COULD_NOT_ASSIGN_CUSTOMER           22
#define PAID_TOO_MUCH                       23
#define CURRENCY_GAINS_LOSS_ACCOUNT_MISSING 24
#define SOME_ACCOUNT_SETTINGS_MISSING       25
#define ACCOUNTS_RECEIVABLE_MISSING         26
#define CANNOT_RETURN                       27
#define CANNOT_MARK_AS_LOSS                 28
#define NO_SALES_ENTRY                      29
#define BAD_SALES_ENTRY                     30
#define BAD_STARTING_BALANCE                31
#define DUPLICATE_STARTING_BALANCE          32
#define NOT_ENOUGH_ROWS                     33
#define CHANGING_METHOD                     34

#define BAD_EXCEL_FORMAT					50


@interface NSManagedObject (ASErrorHandling)

+ (BOOL)mergeValidationError:(NSError *)a withError:(NSError **)error;

@end
