// QR_Encode.h : CQR_Encode NX錾уC^[tFCX`
// Date 2006/05/17	Ver. 1.22	Psytec Inc.


#ifndef _QR_ENCODE_H
#define _QR_ENCODE_H

#include <string.h>
#include <stdlib.h>


/////////////////////////////////////////////////////////////////////////////
// 萔

// x
#define QR_LEVEL_L	0
#define QR_LEVEL_M	1
#define QR_LEVEL_Q	2
#define QR_LEVEL_H	3

// f[^[h
#define QR_MODE_NUMERAL		0
#define QR_MODE_ALPHABET	1
#define QR_MODE_8BIT		2
#define QR_MODE_KANJI		3

// o[W(^)O[v
#define QR_VRESION_S	0 // 1 ` 9
#define QR_VRESION_M	1 // 10 ` 26
#define QR_VRESION_L	2 // 27 ` 40

#define MAX_ALLCODEWORD	 3706 // R[h[hől
#define MAX_DATACODEWORD 2956 // f[^R[h[hől(o[W40-L)
#define MAX_CODEBLOCK	  153 // ubNf[^R[h[hől(qrR[h[h܂)
#define MAX_MODULESIZE	  177 // ӃW[ől

// rbg}bv`掞}[W
#define QR_MARGIN	4


/////////////////////////////////////////////////////////////////////////////
typedef struct tagRS_BLOCKINFO
{
	int ncRSBlock;		// qrubN
	int ncAllCodeWord;	// ubNR[h[h
	int ncDataCodeWord;	// f[^R[h[h(R[h[h - qrR[h[h)

} RS_BLOCKINFO, *LPRS_BLOCKINFO;


/////////////////////////////////////////////////////////////////////////////
// QRR[ho[W(^)֘A

typedef struct tagQR_VERSIONINFO
{
	int nVersionNo;	   // o[W(^)ԍ(1`40)
	int ncAllCodeWord; // R[h[h

	// ȉzY͌(0 = L, 1 = M, 2 = Q, 3 = H) 
	int ncDataCodeWord[4];	// f[^R[h[h(R[h[h - qrR[h[h)

	int ncAlignPoint;	// ACgp^[W
	int nAlignPoint[6];	// ACgp^[SW

	RS_BLOCKINFO RS_BlockInfo1[4]; // qrubN(1)
	RS_BLOCKINFO RS_BlockInfo2[4]; // qrubN(2)

} QR_VERSIONINFO, *LPQR_VERSIONINFO;

typedef unsigned short WORD;

typedef unsigned char BYTE;

typedef BYTE* LPBYTE;

typedef const char* LPCSTR;

#define ZeroMemory(Destination,Length) memset((Destination),0,(Length))


class CQR_Encode
{
// \z/
public:
	CQR_Encode();
	~CQR_Encode();

public:
	int m_nLevel;		// x
	int m_nVersion;		// o[W(^)
	bool m_bAutoExtent;	// o[W(^)gwtO
	int m_nMaskingNo;	// }XLOp^[ԍ

public:
	int m_nSymbleSize;
	BYTE m_byModuleData[MAX_MODULESIZE][MAX_MODULESIZE]; // [x][y]
	// bit5:@\W[i}XLOΏۊOjtO
	// bit4:@\W[`f[^
	// bit1:GR[hf[^
	// bit0:}XNGR[h`f[^
	// 20hƂ̘_aɂ@\W[A11hƂ̘_aɂ`iŏIIɂboollj

private:
	int m_ncDataCodeWordBit; // f[^R[h[hrbg
	BYTE m_byDataCodeWord[MAX_DATACODEWORD]; // ̓f[^GR[hGA

	int m_ncDataBlock;
	BYTE m_byBlockMode[MAX_DATACODEWORD];
	int m_nBlockLength[MAX_DATACODEWORD];

	int m_ncAllCodeWord; // R[h[h(qrf[^܂)
	BYTE m_byAllCodeWord[MAX_ALLCODEWORD]; // R[h[hZoGA
	BYTE m_byRSWork[MAX_CODEBLOCK]; // qrR[h[hZo[N

// f[^GR[h֘At@NV
public:
	bool EncodeData(int nLevel, int nVersion, bool bAutoExtent, int nMaskingNo, LPCSTR lpsSource, int ncSource = 0);

private:
	int GetEncodeVersion(int nVersion, LPCSTR lpsSource, int ncLength);
	bool EncodeSourceData(LPCSTR lpsSource, int ncLength, int nVerGroup);

	int GetBitLength(BYTE nMode, int ncData, int nVerGroup);

	int SetBitStream(int nIndex, WORD wData, int ncData);

	bool IsNumeralData(unsigned char c);
	bool IsAlphabetData(unsigned char c);
	bool IsKanjiData(unsigned char c1, unsigned char c2);

	BYTE AlphabetToBinaly(unsigned char c);
	WORD KanjiToBinaly(WORD wc);

	void GetRSCodeWord(LPBYTE lpbyRSWork, int ncDataCodeWord, int ncRSCodeWord);

// W[zu֘At@NV
private:
	void FormatModule();

	void SetFunctionModule();
	void SetFinderPattern(int x, int y);
	void SetAlignmentPattern(int x, int y);
	void SetVersionPattern();
	void SetCodeWordPattern();
	void SetMaskingPattern(int nPatternNo);
	void SetFormatInfoPattern(int nPatternNo);
	int CountPenalty();
};

/////////////////////////////////////////////////////////////////////////////

#endif