//
//  Row.h
//  iOrdning
//
//  Created by Erik Aderstedt on 2007-11-09.
//  Copyright 2007 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Tag;
@class Account;
@class Entry;

#define RAD_GAMMAL 0
#define RAD_BORTTAGEN 1
#define RAD_NY 2

enum ASVatFreeSalesType {
	kASVatFreeSalesTypeUnknown = 0,
	kASVatFreeSalesTypeNone,
	kASVatFreeSalesTypeInvoice,
	kASVatFreeSalesTypeGoods,
	kASVatFreeSalesTypeServices
};

@interface Row : NSManagedObject {
	NSDecimalNumber					*outgoingBalance; // Transient attribute.
}

@property(retain) NSDecimalNumber	*amount;
@property(retain) NSString			*who;
@property(retain) NSNumber			*when;
@property(retain) NSNumber			*stricken;
@property(retain) NSString			*statementHash;
@property(retain) NSNumber			*number;
@property(retain) Tag				*tag;
@property(retain) Account			*account;
@property(retain) Entry				*entry;
@property(retain) NSDecimalNumber	*outgoingBalance;
@property(retain) NSNumber			*vatFreeSalesType;

// Derived properties
@property(nonatomic, assign)	NSDecimalNumber	*net;
@property(nonatomic, assign)	NSDecimalNumber *debit;
@property(nonatomic, assign)	NSDecimalNumber *credit;
@property(assign,readonly)	NSString		*changeText;
@property(assign)			NSNumber		*accountNumber;

- (void)set:(NSString *)key byId:(id)i;

- (BOOL)isEmpty;
- (BOOL)isRemoved;
+ (NSPredicate *)noRemovedRows;
- (NSNumber *)number;
- (void)setVatFreeSalesCategory:(enum ASVatFreeSalesType)type;

- (void)remove;
- (void)touch;
- (void)copyOtherRow:(Row *)otherRow;
- (void)deleteWithoutPardon;
- (void)makeEntryBalanced;

@end
