//
//  SupplierInvoice.h
//  Economacs
//
//  Created by Erik Aderstedt on 2010-10-06.
//  Copyright 2010 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

enum ASSupplierInvoiceStatus {
	kASSupplierInvoiceNotRegistered,
	kASSupplierInvoiceRegistered,
	kASSupplierInvoicePaid,
	kASSupplierInvoicePartiallyPaid
};

enum ASSupplierInvoiceDateType {
	kASSupplierInvoiceInvoiceDate,
	kASSupplierInvoiceDueDate,
	kASSupplierInvoicePaidDate
};

@class BusinessContact, Company, Entry;

@interface SupplierInvoice : NSManagedObject {

}
@property(retain) NSString *currency;
@property(retain) NSNumber *date;
@property(retain) NSNumber *paidDate;
@property(retain) NSNumber *dueDate;
@property(retain) NSString *reserved; // Comment.
@property(retain) NSString *number;
@property(retain) NSDecimalNumber *exchangeRate;
@property(retain) NSNumber *creditPeriod;
@property(retain) NSDecimalNumber *localAmount;
@property(retain) NSDecimalNumber *paidAmount;
@property(retain) NSNumber *localNumber;

@property(retain) NSString *company;
@property(retain) NSString *street;
@property(retain) NSString *city;
@property(retain) NSString *zipcode;
@property(retain) NSString *county;
@property(retain) NSString *country;
@property(retain) NSString *email;
@property(retain) NSString *phone;
@property(retain) NSString *vatno;
@property(retain) BusinessContact *supplier;
@property(nonatomic,retain) Company *recipient;

- (void)setPropertiesFromLatestInvoice;

- (void)registerInvoiceWithDateIndex:(NSNumber *)d ofType:(enum ASSupplierInvoiceDateType)type exchangeRate:(NSDecimalNumber *)eRate;
- (Entry *)makePayment:(NSDecimalNumber *)amount onDateIndex:(NSNumber *)paid partialPayment:(BOOL)partial;

- (NSDecimalNumber *)totalAmountInclVat;
- (NSDecimalNumber *)totalAmountExclVat;
- (NSDecimalNumber *)remainingAmount;
- (NSAttributedString *)indicator;
- (enum ASSupplierInvoiceStatus)invoiceStatus;
- (void)setInvoiceStatus:(enum ASSupplierInvoiceStatus)s;
- (NSNumber *)isImport;
+ (SupplierInvoice *)latestInManagedObjectContext:(NSManagedObjectContext *)managedObjectContext;
- (SupplierInvoice *)duplicate;
@end
