//
//  Template.h
//  Economacs
//
//  Created by Erik Aderstedt on 2010-07-15.
//  Copyright 2010 Aderstedt Software AB. All rights reserved.
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#import <UIKit/UIKit.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Language;

@interface Template : NSManagedObject {
#if defined(IFAKTURA)
    UIImage	*_preview;
#else
    NSImage	*_preview;
#endif
    
    NSInteger fieldMask; // Used when migrating V5 templates. Just leave it here please.
}
@property (nonatomic,retain) NSString *name;
@property (nonatomic,assign) BOOL replacementCheckComplete;

+ (NSArray *)languagesForTemplateName:(NSString *)name inContext:(NSManagedObjectContext *)moc;
+ (Template *)templateWithName:(NSString *)name inContext:(NSManagedObjectContext *)moc;
+ (NSArray *)templatesForLanguage:(NSString *)lang inContext:(NSManagedObjectContext *)moc;

+ (NSArray *)builtInTemplateNamesInManagedObjectContext:(NSManagedObjectContext *)moc;
- (NSString *)localizedName;

- (Language *)languageWithCode:(NSString *)languageCode;

+ (Template *)templateInContext:(NSManagedObjectContext *)moc;
+ (Template *)defaultTemplateInContext:(NSManagedObjectContext *)moc;
+ (NSArray *)allTemplatesInContext:(NSManagedObjectContext *)moc;

- (void)mergeWithTemplates:(NSArray *)templates;

+ (NSDictionary *)fieldIdentifiers;

@end
