//
//  VatInfo.h
//  Economacs
//
//  Created by Erik Aderstedt on 2012-09-25.
//
//

#if defined(IFAKTURA)
#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#else
#import <Cocoa/Cocoa.h>
#endif

@class Account;

@interface VatInfo : NSManagedObject

@property (retain) Account *vatOnSales;
@property (retain) Account *reverseCharge;
@property (retain) Account *vatOnPurchases;
@property (retain) NSDecimalNumber *level;
@property (retain) NSNumber *index;

+ (instancetype)vatInfoWithLevel:(NSDecimalNumber *)vatLevel inManagedObjectContext:(NSManagedObjectContext *)moc;
+ (instancetype)vatInfoWithIndex:(NSInteger)index inManagedObjectContext:(NSManagedObjectContext *)moc;

@end
