﻿;------------------------------------------------------------
; List Environmental Variables - 1.20  - UNICODE
;------------------------------------------------------------
; This little tool lists the environmental variables of the 
; current process environment in an editor window (supports Ctrl+C)
;------------------------------------------------------------
#title = "Environment Variables "
ID = FindWindow_(0,#title) ; already open? 
If ID : PostMessage_(ID,#WM_CLOSE,0,0) : EndIf ; make other window close itself

#width = 500 : #height = 400 : #list = 1
#flags = #PB_Window_SystemMenu|#PB_Window_MinimizeGadget|#PB_Window_SizeGadget|#PB_Window_ScreenCentered
If OpenWindow(0,0,0,#width,#height,#title,#flags) : Else : End : EndIf 

ListHandle = EditorGadget(#list,0,0,#width,#height,#PB_Editor_ReadOnly) 
SendMessage_(ListHandle,#EM_SETMARGINS,#EC_LEFTMARGIN,5)

If ExamineEnvironmentVariables()
  While NextEnvironmentVariable()
    vname$ = EnvironmentVariableName()
    If vname$
      AddGadgetItem(#list,-1,vname$ + "=" + EnvironmentVariableValue())
    EndIf 
  Wend
EndIf 

SendMessage_(ListHandle,#EM_SETSEL,0,0)
SetActiveGadget(#list)

While WindowEvent() : Wend 
Repeat 
  event = WaitWindowEvent()
  If event = #PB_Event_SizeWindow
    ResizeGadget(#list,#PB_Ignore,#PB_Ignore,WindowWidth(0),WindowHeight(0))
  EndIf 
Until event = #PB_Event_CloseWindow 

End


; IDE Options = PureBasic 4.60 (Windows - x86)
; CursorPosition = 16
; EnableUnicode
; Executable = EnvarList.exe
; DisableDebugger
; CompileSourceDirectory