#!/bin/sh

#echo "Flavours uninstall script"
#echo "-------------------------"

# Make sure we are root
if [[ $EUID -ne 0 ]]; then
    echo "This script must be run as root. Execute as:" 1>&2
    echo "sudo $0" 1>&2
    exit 1
fi

# idiomatic parameter and option handling in sh
REMOVE_APP=0
REMOVE_ALL_DATA=0
while test $# -gt 0
do
    case "$1" in
        --full)
            REMOVE_APP=1
            REMOVE_ALL_DATA=1
            ;;
        --full-except-appbundle)
            REMOVE_APP=0
            REMOVE_ALL_DATA=1
            ;;
        --keep-data)
            REMOVE_APP=1
            REMOVE_ALL_DATA=0
            ;;
        --keep-data-and-appbundle)
            REMOVE_APP=0
            REMOVE_ALL_DATA=0
            ;;
        --*)
            echo "bad argument $1"
            exit 1;;
        *)
            echo "argument $1 not recognized"
            exit 1;;
    esac
    shift
done

# 0. Quit Flavours if running
if [ ${REMOVE_APP} -eq 1 ]; then
    /usr/bin/killall Flavours &>/dev/null
fi

# 1. Restore original Aqua® UI
/usr/bin/restoreui --force &>/dev/null
echo "- restored default Aqua UI"

# 2. Remove caches ($HOME is not user home)
/bin/rm -rf "$HOME/Library/Caches/net.interacto.Flavours/"
echo "- removed Flavours caches"

# 3. Uninstall binaries, libraries, helper tool
# restoreui (keep), flavours.ignitor, flavours.agent, helper, dylibs (keep, otherwise apps launched on this login session would crash!)
/bin/launchctl unload /Library/LaunchAgents/net.interacto.flavours.plist &>/dev/null
/bin/launchctl unload /Library/LaunchAgents/net.interacto.flavours.bg.plist &>/dev/null
/bin/launchctl unload /Library/LaunchDaemons/net.interacto.flavours.helper.plist &>/dev/null
/bin/launchctl unsetenv DYLD_INSERT_LIBRARIES
/bin/rm -rf /usr/local/bin/flavours*
/bin/rm -rf /Library/LaunchAgents/net.interacto.flavours*
/bin/rm -rf /Library/ScriptingAdditions/flavours*
/bin/rm -rf /Library/LaunchDaemons/net.interacto.flavours.helper.plist
/bin/rm -rf /Library/PrivilegedHelperTools/net.interacto.flavours.helper
/bin/rm -rf /var/tmp/net.interacto.flavours.helper
#/bin/rm -rf /usr/local/lib/libflavours*.dylib
echo "- removed Flavours helper binaries & libs"

# 4. Kill all running agents (must remove binaries first)
/usr/bin/killall flavours.agent &>/dev/null
/usr/bin/killall flavours.ignitor &>/dev/null
/usr/bin/killall net.interacto.flavours.helper &>/dev/null
echo "- terminated running processes"

# 5. Remove from Dock
if [ ${REMOVE_APP} -eq 1 ]; then
    dloc=$(sudo -u $SUDO_USER defaults read com.apple.dock persistent-apps | grep _CFURLString\" | awk '/Flavours/ {print NR}' )
    /usr/libexec/PlistBuddy -c "Delete persistent-apps:$dloc" $HOME/Library/Preferences/com.apple.dock.plist
    /usr/bin/killall Dock &>/dev/null
    echo "- removed Flavours from Dock"
fi

# 6. Remove user & shared data
if [ ${REMOVE_ALL_DATA} -eq 1 ]; then
    /bin/rm -rf "$HOME/Library/Application Support/Flavours"
    echo "- removed all Flavours user data"
fi
/bin/rm -rf "/Library/Application Support/Flavours"
echo "- removed all Flavours shared data"

# 7. Make sure OS X isn't blocking the helper tool
/usr/libexec/PlistBuddy -c "Delete net.interacto.flavours.helper" /private/var/db/launchd.db/com.apple.launchd/overrides.plist

# 8. Remove single user mode message
/bin/rm -rf "/var/root/.profile"

# 9. Remove .flavours & backups from CoreUI
/bin/rm -rf /System/Library/PrivateFrameworks/CoreUI.framework/Resources/*.backup
/bin/rm -rf /System/Library/PrivateFrameworks/CoreUI.framework/Resources/*.flavour

# 10. Remove from /Applications
if [ ${REMOVE_APP} -eq 1 ]; then
    /bin/rm -rf /Applications/Flavours.app &>/dev/null
    echo "- removed Flavours from /Applications"
fi

# Recommend to restart
#echo "\nIMPORTANT: it's recommend to restart you Mac for changes to take fully effect!\n"
