//
//  COFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 10.08.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTFont.h"
//@class TTFont;
//@class MGOrderedDictionary;
@class COInfo;
@class COGSUB;
@class COGPOS;
@class OTGDEF;

@class COGlyph;

NSMutableDictionary * reverseCMAP(NSDictionary * Cmap) ;

@interface COFont : NSObject {
	NSString * _path;
	NSString * _fallbackGlyph;
	NSMutableDictionary * _glyphsDict;
	TTFont * _source;
	Class _glyphClass;
//	MGOrderedDictionary * _cmap;
//	MGOrderedDictionary * _reversedCmap;
	NSMutableDictionary * _cmap;
	NSMutableDictionary * _reversedCmap;

	id <GlyphSet> _glyphSet;
	NSArray * _glyphs;
	NSArray * _glyphOrder;
	COInfo * _info;
	COGSUB * _gsub;
	COGPOS * _gpos;
	OTGDEF * _gdef;
}
@property (nonatomic, retain) NSMutableDictionary * glyphsDict;
@property (nonatomic, retain) NSMutableDictionary *cmap;
@property (nonatomic, retain) id <GlyphSet> glyphSet;
@property (nonatomic, retain) NSArray *glyphOrder;
@property (nonatomic, retain) COInfo *info;
@property (nonatomic, readonly) TTFont* source;
@property (nonatomic, retain) NSArray* glyphs;
@property (nonatomic, retain) OTGDEF* gdef;

- (id) initWithPath:(NSString*) Path glyphClass:(Class) GlyphClass ;

- (void) loadCMAP ;
- (void) loadGlyphSet ;
- (void) loadInfo ;
- (void) loadFeatures ;
- (void) resetFeatureStates ;
- (void) setFeatureState:(BOOL) State forTag:(NSString*) FeatureTag ;
- (NSArray*) processGlyphRecords:(NSMutableArray*)GlyphRecords
						  script:(NSString*)theScriptTag
					  langSysTag:(NSString*)theLangSysTag
					 rightToLeft:(BOOL)RightToLeft ;

- (NSArray*) process:(NSString*) String
			  script:(NSString*) theScriptTag
		  langSysTag:(NSString*) theLangSysTag 
		 rightToLeft:(BOOL) RightToLeft ;
- (NSArray*) processAttributed:(NSAttributedString*) AttributedString
						script:(NSString*) theScriptTag
					langSysTag:(NSString*) theLangSysTag
				   rightToLeft:(BOOL) RightToLeft ;
- (COGlyph*) glyphForName:(NSString*) Name;
@end

@interface COInfo : NSObject {
	NSArray * _names;
@public
	NSUInteger unitsPerEm;
	NSUInteger ascender;
	NSInteger descender;
	NSUInteger winAscender;
	NSInteger winDescender;
	NSUInteger xHeight;
	NSUInteger capHeight;
	CGFloat italicAngle;
}
@property (strong) NSArray *names;
@end
