//
//  GSXMLWriter.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

int hexStringToInt(NSString* String);

@interface GSXMLWriter : NSObject {
	NSXMLElement * _root;
	NSMutableArray * _stack;
	FILE *_file;
	const char *_indentwhite;
	NSUInteger _indentlevel;
	BOOL _needindent;
}

- (id) initWithPath:(NSString*)Path ;
- (id) initWithPath:(NSString*)Path indentWhite:(NSString*) indentWhite /*idlefunc=None,*/ encoding:(NSString*)Encoding ;

- (void) close;
- (void) write:(NSString*)data;
- (void) write_noindent:(NSString*)data;
- (void) write8bit:(NSString*)data;
- (void) write16bit:(NSString*)data;
- (void) writeraw:(NSString*)data ;
- (void) newline ;
- (void) comment:(NSString*)data ;
- (void) simpletag:(NSString*) _TAG_ args:(id)args ;
- (void) begintag:(NSString*) _TAG_ args:(id)args ;
- (void) endtag:(NSString*) _TAG_ ;
- (void) dumphex:(NSData*)data ;
- (void) indent ;
- (void) dedent ;
- (NSString*) stringifyattrs: (id)args;


@end