//
//  cffLib.h
//  GSFontTools
//
//  Created by Georg Seifert on 29.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
//#import "cffIndexes.h"
//#import "cffConverter.h"
#import "TTFont.h"
//@class TTFont;
@class GSXMLWriter;
@class CFFPrivateDict;
@class TopDictIndex;
@class IndexedStrings;
@class GlobalSubrsIndex;
@class SubrsIndex;
@class IndexCompiler;
@class FDArrayIndex;
@class FDSelect;
@class GSFileData;
@class OTOrderedDictionary;

//@interface cffLib : NSObject {
//
//}
//
//@end

@interface CFFFontSet : NSObject {
	char _major;
	char _minor;
	char _hdrSize;
	char _offSize;
	NSArray * _fontNames;
	TopDictIndex * _topDictIndex;
	IndexedStrings * _strings;
	GlobalSubrsIndex * _globalSubrs;
}

@property (retain, nonatomic) NSArray * fontNames;
@property (readonly, nonatomic) TopDictIndex * topDictIndex;
- (void) decompile:(GSFileData*) Data;
- (NSUInteger) count;
- (NSArray*) allKeys;
//- (TopDictIndex*) allValues;
- (void) compileToFile:(NSString*) File font:(TTFont*)Font;

- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content;
- (void) toXML:(GSXMLWriter*)Writer;
@end

@interface CFFWriter : NSObject {
}
@end

@interface CFFCharStrings : NSObject <GlyphSet> {
	GlobalSubrsIndex * _globalSubrs;
	CFFPrivateDict * _private;
	FDSelect * _fdSelect;
	FDArrayIndex * _fdArray;
	NSArray * _fdSelectIndex;
	SubrsIndex * _charStringsIndex;
	OTOrderedDictionary * _charStrings;
	BOOL _charStringsAreIndexed;
}

- (id) initWithFile:(GSFileData*)File charset:(NSArray*)Charset globalSubrs:(GlobalSubrsIndex*)GlobalSubrs private:(CFFPrivateDict*)Private fdSelect:(FDSelect*)FdSelect fdArray:(FDArrayIndex*)FdArray;
- (id) glyphForName:(NSString*) Name;
- (id) selectorForName:(NSString*) Name;

@end

@interface IndexedStrings : NSObject {
	NSMutableArray * _strings;
	NSMutableDictionary * _stringMapping;
}
@property (retain, nonatomic) NSMutableArray * strings;

- (id) initWithFile:(GSFileData*) File ;
- (IndexCompiler*) compiler ;
- (NSUInteger) count ;
- (id) stringForSID:(NSUInteger) SID ;
@end

@interface FDSelect : NSObject {
	NSUInteger _format;
	NSMutableDictionary * _gidArray;
}
- (id) initWithFile:(GSFileData*)File numGlyphs:(NSUInteger) NumGlyphs format:(NSUInteger) Format ;
- (NSUInteger) count ;
- (id) objectAtIndex:(NSUInteger)aIndex ;
@end
