//
//  table_C_O_L_R_.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.07.13.
//
//

#import "TTable.h"

@interface table_C_O_L_R_ : TTable {
	uint16_t      _version;                // Table version number (0).
	
//	uint16_t      _numBaseGlyphRecords;    // Number of Base Glyph Records.
//	
//	uint32_t       _offsetBaseGlyphRecord;  // Offset (from beginning of COLR table) to Base Glyph records.
//	
//	uint32_t       _offsetLayerRecord;      // Offset (from beginning of COLR table) to Layer Records.
//	
//	uint16_t      _numLayerRecords;        // Number of Layer Records.
	NSMutableArray * _baseGlyphRecords;
	NSMutableArray * _layerRecords;
}
@property (nonatomic, retain) NSMutableArray* baseGlyphRecords;
@property (nonatomic, retain) NSMutableArray* layerRecords;

@end

@interface OTColrBaseGlyphRecord : NSObject {
	uint16_t _GID;              // Glyph ID of reference glyph. This glyph is for reference only and is not rendered for color.
//	uint16_t _firstLayerIndex;  // Index (from beginning of the Layer Records) to the layer record. There will be numLayers consecutive entries for this base glyph.
//	uint16_t _numLayers;        // Number of color layers associated with this glyph.
	NSRange _layerRange;
}
@property (nonatomic) uint16_t gID;
@property (nonatomic) NSRange layerRange;

- (BOOL) decompile:(NSData*)Data pos:(NSUInteger*)pos font:(TTFont*)Font error:(NSError**)error;
- (BOOL) compile:(NSMutableData*)Data error:(NSError**)error;
@end

@interface OTColrLayerRecord : NSObject {
	uint16_t _gID;            // Glyph ID of layer glyph (must be in z-order from bottom to top).
	uint16_t _paletteIndex;   // Index value to use in the appropriate palette. This value must	be less than numPaletteEntries in the CPAL table, except for the special case noted below. Each palette entry is 16 bits. A palette index of 0xFFFF is a special case indicating that the text foreground color should be used.
}
@property (nonatomic) uint16_t gID;
@property (nonatomic) uint16_t paletteIndex;

- (BOOL) decompile:(NSData*)Data pos:(NSUInteger*)pos font:(TTFont*)Font error:(NSError**)error;
- (BOOL) compile:(NSMutableData*)Data error:(NSError**)error;
- (void) toXML:(GSXMLWriter*) Writer font:(TTFont*)Font;
@end
